/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class SVGStyleParser {
    public static Map parseSVGStyle(String svgStyle) {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (svgStyle == null) {
            return ret;
        }
        StringTokenizer st = new StringTokenizer(svgStyle, ";");
        while (st.hasMoreTokens()) {
            try {
                String style = st.nextToken();
                StringTokenizer st2 = new StringTokenizer(style, ":");
                String key = st2.nextToken().trim();
                String value = st2.nextToken().trim();
                ret.put(key, value);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        return ret;
    }

    public static String getStyleString(Map style) {
        String ret = "";
        if (style == null) {
            return ret;
        }
        Iterator iter = style.keySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next().toString();
            String value = style.get(key).toString();
            if (ret.length() == 0) {
                ret = String.valueOf(ret) + " ";
            }
            ret = String.valueOf(ret) + key + ": " + value + ";";
        }
        return ret;
    }

    public static String getStyleString(String key, String value) {
        return String.valueOf(key) + ": " + value + ";";
    }

    public static String getString(Map style, Object key, String dflt) {
        Object oVal = style.get(key);
        if (oVal == null) {
            return dflt;
        }
        return oVal.toString();
    }

    public static double getDouble(Map style, Object key, double dflt) {
        Object oVal = style.get(key);
        if (oVal == null) {
            return dflt;
        }
        String value = oVal.toString();
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return dflt;
        }
    }

    public static double getInt(Map style, Object key, int dflt) {
        Object oVal = style.get(key);
        if (oVal == null) {
            return dflt;
        }
        String value = oVal.toString();
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return dflt;
        }
    }
}

