/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.RichText;
import gui.TSCFont;
import java.awt.FontMetrics;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.Vector;
import org.apache.batik.svggen.SVGGraphics2D;

public class StringWrappingInfo {
    public RichText s;
    public double[] widths;
    public double lineHeight;
    public double descent;
    public FontMetrics fm;
    public TSCFont font = null;
    public TSCFont origFont;
    protected SVGGraphics2D g;
    protected int orientation = 1;
    public boolean cleanBreaks = false;
    public static final int DEG0 = 1;
    public static final int NORMAL = 1;
    public static final int VERTICAL = 4;
    public static final int DEG90 = 2;
    public static final int DEG180 = 3;
    public static final int DEG270 = 4;

    public StringWrappingInfo(SVGGraphics2D graphics) {
        this.g = graphics;
        this.s = new RichText("");
    }

    public StringWrappingInfo(SVGGraphics2D graphics, RichText string, TSCFont fontToUse, int orientation) {
        this.g = graphics;
        this.font = this.origFont = fontToUse;
        this.fm = this.g.getFontMetrics(fontToUse.getFont());
        this.s = string;
        this.orientation = orientation;
    }

    public StringWrappingInfo(StringWrappingInfo other) {
        this(other.g, new RichText(other.s), other.origFont, other.orientation);
    }

    public boolean isHorizontal() {
        return this.orientation == 1 || this.orientation == 3;
    }

    public boolean isVertical() {
        return this.orientation == 2 || this.orientation == 4;
    }

    public int getRotateDegrees() {
        switch (this.orientation) {
            case 2: {
                return 90;
            }
            case 3: {
                return 180;
            }
            case 4: {
                return 270;
            }
        }
        return 0;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int newOrientation) {
        this.orientation = newOrientation;
    }

    public void flipOrientation() {
        if (this.isHorizontal()) {
            this.setOrientation(4);
        } else {
            this.setOrientation(1);
        }
    }

    public void makeOneLine() {
        this.widths = new double[1];
        this.widths[0] = this.fm.getStringBounds(this.s.getVis(0), this.g).getWidth();
        this.lineHeight = this.fm.getHeight();
        this.descent = this.fm.getDescent();
    }

    public double getHeight() {
        if (this.s == null) {
            return 0.0;
        }
        if (this.isVertical()) {
            return this.getMaxStringWidth();
        }
        if (this.s.getNumLines() == 1 && this.s.getVis(0).trim().length() == 0) {
            return 0.0;
        }
        if (this.s.getNumLines() == 0) {
            return 0.0;
        }
        Rectangle2D lastBounds = this.fm.getStringBounds(this.s.getVis(this.s.getNumLines() - 1), this.g);
        return (double)(this.fm.getHeight() * (this.s.getNumLines() - 1)) + lastBounds.getHeight();
    }

    public double getWidth() {
        if (this.s == null) {
            return 0.0;
        }
        if (this.isVertical()) {
            Rectangle2D lastBounds = this.fm.getStringBounds(this.s.getVis(this.s.getNumLines() - 1), this.g);
            return (double)(this.fm.getHeight() * (this.s.getNumLines() - 1)) + lastBounds.getHeight();
        }
        return this.getMaxStringWidth();
    }

    public double getMaxStringWidth() {
        if (this.s == null) {
            return 0.0;
        }
        double maxWidth = 0.0;
        int i = 0;
        while (i < this.widths.length) {
            if (this.widths[i] > maxWidth) {
                maxWidth = this.widths[i];
            }
            ++i;
        }
        return maxWidth;
    }

    public int getNumLines() {
        if (this.s == null) {
            return 0;
        }
        return this.s.getNumLines();
    }

    public double getFontSize() {
        return this.font.getSize();
    }

    public void setFontSize(int newSize) {
        if (this.font == this.origFont) {
            this.font = new TSCFont(this.origFont);
        }
        this.font.setSize(newSize);
        this.fm = this.g.getFontMetrics(this.font.getFont());
        this.lineHeight = this.fm.getHeight();
        this.descent = this.fm.getDescent();
    }

    public void rewrap(double windowWidth) {
        if (this.isVertical()) {
            this.rewrapVertical(windowWidth);
            return;
        }
        this.s.restore();
        if (windowWidth < 1.0E-6) {
            this.widths = new double[1];
            this.widths[0] = 0.0;
            this.cleanBreaks = false;
            return;
        }
        this.lineHeight = this.fm.getHeight();
        this.descent = this.fm.getDescent();
        this.s.splitOnNewlines(-1);
        if (this.s.getNumLines() == 1 && (double)this.fm.stringWidth(this.s.getVis(0)) < windowWidth) {
            this.calcWidths();
            return;
        }
        int i = 0;
        while (i < this.s.getNumLines()) {
            RichText.Line line = this.s.getLine(i);
            boolean allowEmptyLine = false;
            int cutPoint = line.getVisibleString().length();
            String cut = line.getVisibleString();
            int cutWidth = this.fm.stringWidth(cut);
            while ((double)cutWidth > windowWidth && cutPoint > 1) {
                int lastIndex = RichText.getLastBreak(cut, cut.length());
                if (lastIndex < 0) {
                    --cutPoint;
                    allowEmptyLine = true;
                    this.cleanBreaks = false;
                } else {
                    cutPoint = lastIndex;
                }
                cut = cut.substring(0, cutPoint).trim();
                cutWidth = this.fm.stringWidth(cut);
            }
            if (cutPoint != line.getVisibleString().length() && cutPoint > 0) {
                line.splitVisibleLine(cutPoint, true);
            }
            ++i;
        }
        this.calcWidths();
    }

    protected void calcWidths() {
        this.widths = new double[this.s.getNumLines()];
        int i = 0;
        while (i < this.s.getNumLines()) {
            RichText.Line line = this.s.getLine(i);
            Rectangle2D rect = this.fm.getStringBounds(line.getVisibleString(), this.g);
            this.widths[i] = rect.getWidth();
            Iterator iter = line.elements.iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (!(o instanceof RichText.StringElement)) continue;
                RichText.StringElement se = (RichText.StringElement)o;
                rect = this.fm.getStringBounds(se.visibleString(), this.g);
                se.width = rect.getWidth();
            }
            ++i;
        }
    }

    protected void rewrapVertical(double windowWidth) {
        this.s.restore();
        this.lineHeight = this.fm.getHeight();
        this.descent = this.fm.getDescent();
        int numLines = (int)Math.floor(windowWidth / this.lineHeight);
        if (numLines < 1) {
            numLines = 1;
        }
        this.s.splitOnNewlines(numLines);
        if (this.s.getNumLines() == 1 && (double)this.fm.stringWidth(this.s.getVis(0)) < windowWidth) {
            this.calcWidths();
            return;
        }
        Vector<Boolean> noSplit = new Vector<Boolean>(numLines);
        int i = 0;
        while (i < this.s.getNumLines()) {
            noSplit.add(new Boolean(false));
            ++i;
        }
        while (this.s.getNumLines() < numLines) {
            int splitLine = -1;
            int maxLength = 2;
            int i2 = 0;
            while (i2 < this.s.getNumLines()) {
                String l = this.s.getVis(i2);
                if (l.length() > maxLength && !((Boolean)noSplit.get(i2)).booleanValue()) {
                    splitLine = i2;
                    maxLength = l.length();
                }
                ++i2;
            }
            if (splitLine == -1) break;
            RichText.Line line = this.s.getLine(splitLine);
            int cutPoint = line.getVisibleString().length() / 2;
            if ((cutPoint = line.getLastBreak(cutPoint)) < 0) {
                cutPoint = line.getBreak(line.getVisibleString().length() / 2 - 1);
            }
            if (cutPoint < 0) {
                noSplit.set(splitLine, new Boolean(true));
                continue;
            }
            if (line.splitVisibleLine(cutPoint, true) == null) continue;
            noSplit.add(new Boolean(false));
        }
        this.calcWidths();
    }

    public void wrap(double width) {
        this.rewrap(width);
    }

    public StringWrappingInfo wrapString(RichText input, double windowWidth, TSCFont fontToUse) {
        this.font = this.origFont = fontToUse;
        this.fm = this.g.getFontMetrics(fontToUse.getFont());
        this.s = input;
        this.rewrap(windowWidth);
        return this;
    }

    public String toString() {
        String ret = "";
        if (this.s == null) {
            return ret;
        }
        int i = 0;
        while (i < this.s.getNumLines()) {
            if (ret.length() > 0) {
                ret = String.valueOf(ret) + "\n";
            }
            String l = this.s.getVis(i);
            ret = String.valueOf(ret) + l.replaceAll("\n", "").replaceAll("\r", "");
            ++i;
        }
        return ret;
    }
}

