/*
 * Decompiled with CFR 0.152.
 */
package gui;

public class Vector2D {
    public double x;
    public double y;

    public Vector2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Vector2D(Vector2D s) {
        this.x = s.x;
        this.y = s.y;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public void normalize() {
        double l = this.length();
        this.x /= l;
        this.y /= l;
    }

    public void setLength(double l) {
        double cl = this.length();
        double mul = l / cl;
        this.x *= mul;
        this.y *= mul;
    }

    public void mul(double factor) {
        this.x *= factor;
        this.y *= factor;
    }

    public Vector2D add(Vector2D o) {
        return new Vector2D(this.x + o.x, this.y + o.y);
    }

    public void add(double xa, double ya) {
        this.x += xa;
        this.y += ya;
    }

    public double dotProduct(Vector2D o) {
        return this.x * o.x + this.y * o.y;
    }

    public void perpSlope() {
        double temp = this.x;
        this.x = this.y;
        this.y = temp;
        this.x *= 1.0;
        this.y *= -1.0;
    }
}

