/*
 * Decompiled with CFR 0.152.
 */
package gui.tree;

import datastore.DataColumn;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;

public class CheckboxTreeCellEditor
implements TreeCellEditor {
    JTree tree;

    public CheckboxTreeCellEditor(JTree t) {
        this.tree = t;
    }

    public Component getTreeCellEditorComponent(JTree tree, Object obj, boolean selected, boolean expanded, boolean leaf, int row) {
        DataColumn node = (DataColumn)obj;
        JPanel p = node.panel;
        return p;
    }

    public void cancelCellEditing() {
    }

    public boolean stopCellEditing() {
        return true;
    }

    public Object getCellEditorValue() {
        return this;
    }

    public boolean isCellEditable(EventObject evt) {
        int row;
        TreePath path;
        MouseEvent mevt;
        if (evt instanceof MouseEvent && (mevt = (MouseEvent)evt).getClickCount() == 1 && (path = this.tree.getPathForRow(row = this.tree.getRowForLocation(mevt.getX(), mevt.getY()))) != null) {
            DataColumn node = (DataColumn)path.getLastPathComponent();
            Rectangle nodeBounds = this.tree.getRowBounds(row);
            Point p = mevt.getPoint();
            p.x -= nodeBounds.x;
            p.y -= nodeBounds.y;
            if (node.willThisCheck(p)) {
                return true;
            }
        }
        return false;
    }

    public boolean shouldSelectCell(EventObject evt) {
        int row;
        TreePath path;
        MouseEvent mevt;
        if (evt instanceof MouseEvent && (mevt = (MouseEvent)evt).getClickCount() == 1 && (path = this.tree.getPathForRow(row = this.tree.getRowForLocation(mevt.getX(), mevt.getY()))) != null) {
            DataColumn node = (DataColumn)path.getLastPathComponent();
            Rectangle nodeBounds = this.tree.getRowBounds(row);
            Point p = mevt.getPoint();
            p.x -= nodeBounds.x;
            p.y -= nodeBounds.y;
            if (node.willThisCheck(p)) {
                return false;
            }
        }
        return true;
    }

    public void addCellEditorListener(CellEditorListener cl) {
    }

    public void removeCellEditorListener(CellEditorListener cl) {
    }
}

