/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.Area;
import org.apache.fop.area.AreaTreeModel;
import org.apache.fop.area.Block;
import org.apache.fop.area.BlockParent;
import org.apache.fop.area.BlockViewport;
import org.apache.fop.area.BodyRegion;
import org.apache.fop.area.CTM;
import org.apache.fop.area.LineArea;
import org.apache.fop.area.NormalFlow;
import org.apache.fop.area.OffDocumentExtensionAttachment;
import org.apache.fop.area.Page;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.RegionReference;
import org.apache.fop.area.RegionViewport;
import org.apache.fop.area.Span;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.AbstractTextArea;
import org.apache.fop.area.inline.Character;
import org.apache.fop.area.inline.ForeignObject;
import org.apache.fop.area.inline.Image;
import org.apache.fop.area.inline.InlineBlockParent;
import org.apache.fop.area.inline.InlineParent;
import org.apache.fop.area.inline.Leader;
import org.apache.fop.area.inline.Space;
import org.apache.fop.area.inline.SpaceArea;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.area.inline.Viewport;
import org.apache.fop.area.inline.WordArea;
import org.apache.fop.fo.ElementMappingRegistry;
import org.apache.fop.fo.extensions.ExtensionAttachment;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.ImageFactory;
import org.apache.fop.traits.BorderProps;
import org.apache.fop.util.ContentHandlerFactory;
import org.apache.fop.util.ContentHandlerFactoryRegistry;
import org.apache.fop.util.DefaultErrorListener;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AreaTreeParser {
    protected static Log log = LogFactory.getLog(class$org$apache$fop$area$AreaTreeParser == null ? (class$org$apache$fop$area$AreaTreeParser = AreaTreeParser.class$("org.apache.fop.area.AreaTreeParser")) : class$org$apache$fop$area$AreaTreeParser);
    private static SAXTransformerFactory tFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
    static /* synthetic */ Class class$org$apache$fop$area$AreaTreeParser;

    public void parse(Source src, AreaTreeModel treeModel, FOUserAgent userAgent) throws TransformerException {
        Transformer transformer = tFactory.newTransformer();
        transformer.setErrorListener(new DefaultErrorListener(log));
        SAXResult res = new SAXResult(this.getContentHandler(treeModel, userAgent));
        transformer.transform(src, res);
    }

    public ContentHandler getContentHandler(AreaTreeModel treeModel, FOUserAgent userAgent) {
        ElementMappingRegistry elementMappingRegistry = userAgent.getFactory().getElementMappingRegistry();
        return new Handler(treeModel, userAgent, elementMappingRegistry);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Handler
    extends DefaultHandler {
        private Map makers = new HashMap();
        private AreaTreeModel treeModel;
        private FOUserAgent userAgent;
        private ElementMappingRegistry elementMappingRegistry;
        private Attributes lastAttributes;
        private StringBuffer content = new StringBuffer();
        private PageViewport currentPageViewport;
        private Stack areaStack = new Stack();
        private boolean firstFlow;
        private boolean pendingStartPageSequence;
        private Stack delegateStack = new Stack();
        private ContentHandler delegate;
        private DOMImplementation domImplementation;
        private static final Object[] SUBSET_COMMON = new Object[]{Trait.PROD_ID};
        private static final Object[] SUBSET_LINK = new Object[]{Trait.INTERNAL_LINK, Trait.EXTERNAL_LINK};
        private static final Object[] SUBSET_COLOR = new Object[]{Trait.BACKGROUND, Trait.COLOR};
        private static final Object[] SUBSET_FONT = new Object[]{Trait.FONT, Trait.FONT_SIZE, Trait.BLINK, Trait.OVERLINE, Trait.OVERLINE_COLOR, Trait.LINETHROUGH, Trait.LINETHROUGH_COLOR, Trait.UNDERLINE, Trait.UNDERLINE_COLOR};
        private static final Object[] SUBSET_BOX = new Object[]{Trait.BORDER_BEFORE, Trait.BORDER_AFTER, Trait.BORDER_START, Trait.BORDER_END, Trait.SPACE_BEFORE, Trait.SPACE_AFTER, Trait.SPACE_START, Trait.SPACE_END, Trait.PADDING_BEFORE, Trait.PADDING_AFTER, Trait.PADDING_START, Trait.PADDING_END, Trait.START_INDENT, Trait.END_INDENT, Trait.IS_REFERENCE_AREA, Trait.IS_VIEWPORT_AREA};
        static /* synthetic */ Class class$org$apache$fop$area$RegionViewport;
        static /* synthetic */ Class class$org$apache$fop$area$BodyRegion;
        static /* synthetic */ Class class$org$apache$fop$area$BlockParent;
        static /* synthetic */ Class class$org$apache$fop$area$inline$AbstractTextArea;
        static /* synthetic */ Class class$org$apache$fop$area$inline$Viewport;
        static /* synthetic */ Class class$java$lang$Integer;
        static /* synthetic */ Class class$java$lang$Boolean;
        static /* synthetic */ Class class$java$lang$String;
        static /* synthetic */ Class class$org$apache$fop$area$Trait$Color;
        static /* synthetic */ Class class$org$apache$fop$area$Trait$Background;
        static /* synthetic */ Class class$org$apache$fop$traits$BorderProps;

        public Handler(AreaTreeModel treeModel, FOUserAgent userAgent, ElementMappingRegistry elementMappingRegistry) {
            this.treeModel = treeModel;
            this.userAgent = userAgent;
            this.elementMappingRegistry = elementMappingRegistry;
            this.makers.put("areaTree", new AreaTreeMaker());
            this.makers.put("page", new PageMaker());
            this.makers.put("pageSequence", new PageSequenceMaker());
            this.makers.put("title", new TitleMaker());
            this.makers.put("pageViewport", new PageViewportMaker());
            this.makers.put("regionViewport", new RegionViewportMaker());
            this.makers.put("regionBefore", new RegionBeforeMaker());
            this.makers.put("regionAfter", new RegionAfterMaker());
            this.makers.put("regionStart", new RegionStartMaker());
            this.makers.put("regionEnd", new RegionEndMaker());
            this.makers.put("regionBody", new RegionBodyMaker());
            this.makers.put("flow", new FlowMaker());
            this.makers.put("mainReference", new MainReferenceMaker());
            this.makers.put("span", new SpanMaker());
            this.makers.put("footnote", new FootnoteMaker());
            this.makers.put("beforeFloat", new BeforeFloatMaker());
            this.makers.put("block", new BlockMaker());
            this.makers.put("lineArea", new LineAreaMaker());
            this.makers.put("inlineparent", new InlineParentMaker());
            this.makers.put("inlineblockparent", new InlineBlockParentMaker());
            this.makers.put("text", new TextMaker());
            this.makers.put("word", new WordMaker());
            this.makers.put("space", new SpaceMaker());
            this.makers.put("char", new CharMaker());
            this.makers.put("leader", new LeaderMaker());
            this.makers.put("viewport", new ViewportMaker());
            this.makers.put("image", new ImageMaker());
            this.makers.put("foreignObject", new ForeignObjectMaker());
        }

        private static Rectangle2D parseRect(String rect) {
            StringTokenizer tokenizer = new StringTokenizer(rect, " ");
            return new Rectangle2D.Double(Double.parseDouble(tokenizer.nextToken()), Double.parseDouble(tokenizer.nextToken()), Double.parseDouble(tokenizer.nextToken()), Double.parseDouble(tokenizer.nextToken()));
        }

        /*
         * Unable to fully structure code
         */
        private Area findAreaType(Class clazz) {
            block2: {
                if (this.areaStack.size() <= 0) break block2;
                pos = this.areaStack.size() - 1;
                obj = null;
                if (true) ** GOTO lbl7
                do {
                    --pos;
lbl7:
                    // 2 sources

                    if (pos < 0) break;
                    v0 = this.areaStack.get(pos);
                    obj = v0;
                } while (!clazz.isInstance(v0));
                if (pos >= 0) {
                    return obj;
                }
            }
            return null;
        }

        private RegionViewport getCurrentRegionViewport() {
            return (RegionViewport)this.findAreaType(class$org$apache$fop$area$RegionViewport == null ? (class$org$apache$fop$area$RegionViewport = Handler.class$("org.apache.fop.area.RegionViewport")) : class$org$apache$fop$area$RegionViewport);
        }

        private BodyRegion getCurrentBodyRegion() {
            return (BodyRegion)this.findAreaType(class$org$apache$fop$area$BodyRegion == null ? (class$org$apache$fop$area$BodyRegion = Handler.class$("org.apache.fop.area.BodyRegion")) : class$org$apache$fop$area$BodyRegion);
        }

        private BlockParent getCurrentBlockParent() {
            return (BlockParent)this.findAreaType(class$org$apache$fop$area$BlockParent == null ? (class$org$apache$fop$area$BlockParent = Handler.class$("org.apache.fop.area.BlockParent")) : class$org$apache$fop$area$BlockParent);
        }

        private AbstractTextArea getCurrentText() {
            return (AbstractTextArea)this.findAreaType(class$org$apache$fop$area$inline$AbstractTextArea == null ? (class$org$apache$fop$area$inline$AbstractTextArea = Handler.class$("org.apache.fop.area.inline.AbstractTextArea")) : class$org$apache$fop$area$inline$AbstractTextArea);
        }

        private Viewport getCurrentViewport() {
            return (Viewport)this.findAreaType(class$org$apache$fop$area$inline$Viewport == null ? (class$org$apache$fop$area$inline$Viewport = Handler.class$("org.apache.fop.area.inline.Viewport")) : class$org$apache$fop$area$inline$Viewport);
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.delegate != null) {
                this.delegateStack.push(qName);
                this.delegate.startElement(uri, localName, qName, attributes);
            } else if (this.domImplementation != null) {
                TransformerHandler handler;
                try {
                    handler = tFactory.newTransformerHandler();
                }
                catch (TransformerConfigurationException e) {
                    throw new SAXException("Error creating a new TransformerHandler", e);
                }
                Document doc = this.domImplementation.createDocument(uri, qName, null);
                doc.removeChild(doc.getDocumentElement());
                handler.setResult(new DOMResult(doc));
                Area parent = (Area)this.areaStack.peek();
                ((ForeignObject)parent).setDocument(doc);
                this.domImplementation = null;
                this.delegate = handler;
                this.delegateStack.push(qName);
                this.delegate.startDocument();
                this.delegate.startElement(uri, localName, qName, attributes);
            } else {
                this.lastAttributes = attributes;
                boolean handled = true;
                if ("".equals(uri)) {
                    Maker maker = (Maker)this.makers.get(localName);
                    if (maker != null) {
                        maker.startElement(attributes);
                    } else if (!"extension-attachments".equals(localName)) {
                        handled = false;
                    }
                } else {
                    ContentHandlerFactoryRegistry registry = this.userAgent.getFactory().getContentHandlerFactoryRegistry();
                    ContentHandlerFactory factory = registry.getFactory(uri);
                    if (factory != null) {
                        this.delegate = factory.createContentHandler();
                        this.delegateStack.push(qName);
                        this.delegate.startDocument();
                        this.delegate.startElement(uri, localName, qName, attributes);
                    } else {
                        handled = false;
                    }
                }
                if (!handled) {
                    if (uri == null || uri.length() == 0) {
                        throw new SAXException("Unhandled element " + localName + " in namespace: " + uri);
                    }
                    log.warn("Unhandled element " + localName + " in namespace: " + uri);
                }
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.delegate != null) {
                this.delegate.endElement(uri, localName, qName);
                this.delegateStack.pop();
                if (this.delegateStack.size() == 0) {
                    this.delegate.endDocument();
                    if (this.delegate instanceof ContentHandlerFactory.ObjectSource) {
                        Object obj = ((ContentHandlerFactory.ObjectSource)((Object)this.delegate)).getObject();
                        this.handleExternallyGeneratedObject(obj);
                    }
                    this.delegate = null;
                }
            } else {
                Maker maker;
                if ("".equals(uri) && (maker = (Maker)this.makers.get(localName)) != null) {
                    maker.endElement();
                }
                this.content.setLength(0);
            }
        }

        private void pushNewRegionReference(Attributes attributes, int side) {
            String regionName = attributes.getValue("name");
            RegionViewport rv = this.getCurrentRegionViewport();
            RegionReference reg = new RegionReference(side, regionName, rv);
            reg.setCTM(this.getAttributeAsCTM(attributes, "ctm"));
            this.setAreaAttributes(attributes, reg);
            rv.setRegionReference(reg);
            this.currentPageViewport.getPage().setRegionViewport(side, rv);
            this.areaStack.push(reg);
        }

        private void assertObjectOfClass(Object obj, Class clazz) {
            if (!clazz.isInstance(obj)) {
                throw new IllegalStateException("Object is not an instance of " + clazz.getName() + " but of " + obj.getClass().getName());
            }
        }

        protected void handleExternallyGeneratedObject(Object obj) {
            if (this.areaStack.size() == 0 && obj instanceof ExtensionAttachment) {
                ExtensionAttachment attachment = (ExtensionAttachment)obj;
                if (this.currentPageViewport == null) {
                    this.treeModel.handleOffDocumentItem(new OffDocumentExtensionAttachment(attachment));
                } else {
                    this.currentPageViewport.addExtensionAttachment(attachment);
                }
            } else {
                log.warn("Don't know how to handle externally generated object: " + obj);
            }
        }

        private void setAreaAttributes(Attributes attributes, Area area) {
            area.setIPD(Integer.parseInt(attributes.getValue("ipd")));
            area.setBPD(Integer.parseInt(attributes.getValue("bpd")));
        }

        private void setTraits(Attributes attributes, Area area, Object[] traitSubset) {
            int i = 0;
            int c = traitSubset.length;
            while (i < c) {
                String fontName;
                Object trait = traitSubset[i];
                String traitName = Trait.getTraitName(trait);
                String value = attributes.getValue(traitName);
                if (value != null) {
                    Class cl = Trait.getTraitClass(trait);
                    if (cl == (class$java$lang$Integer == null ? Handler.class$("java.lang.Integer") : class$java$lang$Integer)) {
                        area.addTrait(trait, new Integer(value));
                    } else if (cl == (class$java$lang$Boolean == null ? Handler.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                        area.addTrait(trait, Boolean.valueOf(value));
                    } else if (cl == (class$java$lang$String == null ? Handler.class$("java.lang.String") : class$java$lang$String)) {
                        area.addTrait(trait, value);
                    } else if (cl == (class$org$apache$fop$area$Trait$Color == null ? Handler.class$("org.apache.fop.area.Trait$Color") : class$org$apache$fop$area$Trait$Color)) {
                        area.addTrait(trait, Trait.Color.valueOf(value));
                    } else if (cl == (class$org$apache$fop$area$Trait$Background == null ? Handler.class$("org.apache.fop.area.Trait$Background") : class$org$apache$fop$area$Trait$Background)) {
                        String url;
                        Trait.Background bkg = new Trait.Background();
                        Trait.Color col = Trait.Color.valueOf(attributes.getValue("bkg-color"));
                        if (col != null) {
                            bkg.setColor(col);
                        }
                        if ((url = attributes.getValue("bkg-img")) != null) {
                            bkg.setURL(url);
                            ImageFactory fact = this.userAgent.getFactory().getImageFactory();
                            FopImage img = fact.getImage(url, this.userAgent);
                            if (img == null) {
                                log.error("Background image not available: " + url);
                            } else if (!img.load(1)) {
                                log.error("Cannot read background image dimensions: " + url);
                            }
                            bkg.setFopImage(img);
                            String repeat = attributes.getValue("bkg-repeat");
                            if (repeat != null) {
                                bkg.setRepeat(repeat);
                            }
                            bkg.setHoriz(this.getAttributeAsInteger(attributes, "bkg-horz-offset", 0));
                            bkg.setVertical(this.getAttributeAsInteger(attributes, "bkg-vert-offset", 0));
                        }
                        area.addTrait(trait, bkg);
                    } else if (cl == (class$org$apache$fop$traits$BorderProps == null ? Handler.class$("org.apache.fop.traits.BorderProps") : class$org$apache$fop$traits$BorderProps)) {
                        area.addTrait(trait, BorderProps.valueOf(value));
                    }
                } else if (trait == Trait.FONT && (fontName = attributes.getValue("font-name")) != null) {
                    String fontStyle = attributes.getValue("font-style");
                    int fontWeight = this.getAttributeAsInteger(attributes, "font-weight", 400);
                    area.addTrait(trait, FontInfo.createFontKey(fontName, fontStyle, fontWeight));
                }
                ++i;
            }
        }

        private boolean getAttributeAsBoolean(Attributes attributes, String name, boolean defaultValue) {
            String s = attributes.getValue(name);
            if (s == null) {
                return defaultValue;
            }
            return Boolean.valueOf(s);
        }

        private int getAttributeAsInteger(Attributes attributes, String name, int defaultValue) {
            String s = attributes.getValue(name);
            if (s == null) {
                return defaultValue;
            }
            return Integer.parseInt(s);
        }

        private CTM getAttributeAsCTM(Attributes attributes, String name) {
            String s = attributes.getValue(name).trim();
            if (s.startsWith("[") && s.endsWith("]")) {
                s = s.substring(1, s.length() - 1);
                StringTokenizer tokenizer = new StringTokenizer(s, " ");
                double[] values = new double[]{Double.parseDouble(tokenizer.nextToken()), Double.parseDouble(tokenizer.nextToken()), Double.parseDouble(tokenizer.nextToken()), Double.parseDouble(tokenizer.nextToken()), Double.parseDouble(tokenizer.nextToken()), Double.parseDouble(tokenizer.nextToken())};
                return new CTM(values[0], values[1], values[2], values[3], values[4], values[5]);
            }
            throw new IllegalArgumentException("CTM must be surrounded by square brackets");
        }

        private Rectangle2D getAttributeAsRectangle2D(Attributes attributes, String name) {
            String s = attributes.getValue(name).trim();
            StringTokenizer tokenizer = new StringTokenizer(s, " ");
            double[] values = new double[]{Double.parseDouble(tokenizer.nextToken()), Double.parseDouble(tokenizer.nextToken()), Double.parseDouble(tokenizer.nextToken()), Double.parseDouble(tokenizer.nextToken())};
            return new Rectangle2D.Double(values[0], values[1], values[2], values[3]);
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.delegate != null) {
                this.delegate.characters(ch, start, length);
            } else {
                this.content.append(ch, start, length);
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        private class ForeignObjectMaker
        extends AbstractMaker {
            static /* synthetic */ Class class$org$apache$fop$area$inline$ForeignObject;

            private ForeignObjectMaker() {
            }

            public void startElement(Attributes attributes) throws SAXException {
                String ns = attributes.getValue("ns");
                Handler.this.domImplementation = Handler.this.elementMappingRegistry.getDOMImplementationForNamespace(ns);
                if (Handler.this.domImplementation == null) {
                    throw new SAXException("No DOMImplementation could be identified to handle namespace: " + ns);
                }
                ForeignObject foreign = new ForeignObject(ns);
                Handler.this.setAreaAttributes(attributes, foreign);
                Handler.this.setTraits(attributes, foreign, SUBSET_COMMON);
                Handler.this.getCurrentViewport().setContent(foreign);
                Handler.this.areaStack.push(foreign);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), ForeignObjectMaker.class$org$apache$fop$area$inline$ForeignObject == null ? (ForeignObjectMaker.class$org$apache$fop$area$inline$ForeignObject = ForeignObjectMaker.class$("org.apache.fop.area.inline.ForeignObject")) : ForeignObjectMaker.class$org$apache$fop$area$inline$ForeignObject);
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        }

        private class ImageMaker
        extends AbstractMaker {
            private ImageMaker() {
            }

            public void startElement(Attributes attributes) {
                String url = attributes.getValue("url");
                Image image = new Image(url);
                Handler.this.setAreaAttributes(attributes, image);
                Handler.this.setTraits(attributes, image, SUBSET_COMMON);
                Handler.this.getCurrentViewport().setContent(image);
            }
        }

        private class ViewportMaker
        extends AbstractMaker {
            static /* synthetic */ Class class$org$apache$fop$area$inline$Viewport;

            private ViewportMaker() {
            }

            public void startElement(Attributes attributes) {
                Viewport viewport = new Viewport(null);
                Handler.this.setAreaAttributes(attributes, viewport);
                Handler.this.setTraits(attributes, viewport, SUBSET_COMMON);
                Handler.this.setTraits(attributes, viewport, SUBSET_BOX);
                Handler.this.setTraits(attributes, viewport, SUBSET_COLOR);
                viewport.setContentPosition(Handler.this.getAttributeAsRectangle2D(attributes, "pos"));
                viewport.setClip(Handler.this.getAttributeAsBoolean(attributes, "clip", false));
                viewport.setOffset(Handler.this.getAttributeAsInteger(attributes, "offset", 0));
                Area parent = (Area)Handler.this.areaStack.peek();
                parent.addChildArea(viewport);
                Handler.this.areaStack.push(viewport);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), ViewportMaker.class$org$apache$fop$area$inline$Viewport == null ? (ViewportMaker.class$org$apache$fop$area$inline$Viewport = ViewportMaker.class$("org.apache.fop.area.inline.Viewport")) : ViewportMaker.class$org$apache$fop$area$inline$Viewport);
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        }

        private class LeaderMaker
        extends AbstractMaker {
            private LeaderMaker() {
            }

            public void startElement(Attributes attributes) {
                Leader leader = new Leader();
                Handler.this.setAreaAttributes(attributes, leader);
                Handler.this.setTraits(attributes, leader, SUBSET_COMMON);
                Handler.this.setTraits(attributes, leader, SUBSET_BOX);
                Handler.this.setTraits(attributes, leader, SUBSET_COLOR);
                Handler.this.setTraits(attributes, leader, SUBSET_FONT);
                leader.setOffset(Handler.this.getAttributeAsInteger(attributes, "offset", 0));
                String ruleStyle = attributes.getValue("ruleStyle");
                if (ruleStyle != null) {
                    leader.setRuleStyle(ruleStyle);
                }
                leader.setRuleThickness(Handler.this.getAttributeAsInteger(attributes, "ruleThickness", 0));
                Area parent = (Area)Handler.this.areaStack.peek();
                parent.addChildArea(leader);
            }

            public void endElement() {
            }
        }

        private class CharMaker
        extends AbstractMaker {
            private CharMaker() {
            }

            public void endElement() {
                String txt = Handler.this.content.toString();
                Character ch = new Character(txt.charAt(0));
                Handler.this.setAreaAttributes(Handler.this.lastAttributes, ch);
                Handler.this.setTraits(Handler.this.lastAttributes, ch, SUBSET_COMMON);
                Handler.this.setTraits(Handler.this.lastAttributes, ch, SUBSET_BOX);
                Handler.this.setTraits(Handler.this.lastAttributes, ch, SUBSET_COLOR);
                Handler.this.setTraits(Handler.this.lastAttributes, ch, SUBSET_FONT);
                ch.setOffset(Handler.this.getAttributeAsInteger(Handler.this.lastAttributes, "offset", 0));
                ch.setBaselineOffset(Handler.this.getAttributeAsInteger(Handler.this.lastAttributes, "baseline", 0));
                Area parent = (Area)Handler.this.areaStack.peek();
                parent.addChildArea(ch);
            }
        }

        private class SpaceMaker
        extends AbstractMaker {
            private SpaceMaker() {
            }

            public void endElement() {
                int offset = Handler.this.getAttributeAsInteger(Handler.this.lastAttributes, "offset", 0);
                String txt = Handler.this.content.toString();
                if (txt.length() > 0) {
                    boolean adjustable = Handler.this.getAttributeAsBoolean(Handler.this.lastAttributes, "adj", true);
                    SpaceArea space = new SpaceArea(txt.charAt(0), offset, adjustable);
                    AbstractTextArea text = Handler.this.getCurrentText();
                    space.setParentArea(text);
                    text.addChildArea(space);
                } else {
                    Space space = new Space();
                    Handler.this.setAreaAttributes(Handler.this.lastAttributes, space);
                    Handler.this.setTraits(Handler.this.lastAttributes, space, SUBSET_COMMON);
                    Handler.this.setTraits(Handler.this.lastAttributes, space, SUBSET_BOX);
                    Handler.this.setTraits(Handler.this.lastAttributes, space, SUBSET_COLOR);
                    space.setOffset(offset);
                    Area parent = (Area)Handler.this.areaStack.peek();
                    parent.addChildArea(space);
                }
            }
        }

        private class WordMaker
        extends AbstractMaker {
            private WordMaker() {
            }

            private int[] toIntArray(String s) {
                if (s == null || s.length() == 0) {
                    return null;
                }
                StringTokenizer tokenizer = new StringTokenizer(s, " ");
                ArrayList<Integer> values = new ArrayList<Integer>();
                while (tokenizer.hasMoreTokens()) {
                    values.add(new Integer(tokenizer.nextToken()));
                }
                int[] res = new int[values.size()];
                int i = 0;
                int c = res.length;
                while (i < c) {
                    res[i] = (Integer)values.get(i);
                    ++i;
                }
                return res;
            }

            public void endElement() {
                int offset = Handler.this.getAttributeAsInteger(Handler.this.lastAttributes, "offset", 0);
                int[] letterAdjust = this.toIntArray(Handler.this.lastAttributes.getValue("letter-adjust"));
                String txt = Handler.this.content.toString();
                WordArea word = new WordArea(txt, offset, letterAdjust);
                AbstractTextArea text = Handler.this.getCurrentText();
                word.setParentArea(text);
                text.addChildArea(word);
            }
        }

        private class TextMaker
        extends AbstractMaker {
            static /* synthetic */ Class class$org$apache$fop$area$inline$TextArea;

            private TextMaker() {
            }

            public void startElement(Attributes attributes) {
                if (Handler.this.getCurrentText() != null) {
                    throw new IllegalStateException("Current Text must be null");
                }
                TextArea text = new TextArea();
                Handler.this.setAreaAttributes(attributes, text);
                Handler.this.setTraits(attributes, text, SUBSET_COMMON);
                Handler.this.setTraits(attributes, text, SUBSET_BOX);
                Handler.this.setTraits(attributes, text, SUBSET_COLOR);
                Handler.this.setTraits(attributes, text, SUBSET_FONT);
                text.setBaselineOffset(Handler.this.getAttributeAsInteger(attributes, "baseline", 0));
                text.setOffset(Handler.this.getAttributeAsInteger(attributes, "offset", 0));
                text.setTextLetterSpaceAdjust(Handler.this.getAttributeAsInteger(attributes, "tlsadjust", 0));
                text.setTextWordSpaceAdjust(Handler.this.getAttributeAsInteger(attributes, "twsadjust", 0));
                Area parent = (Area)Handler.this.areaStack.peek();
                parent.addChildArea(text);
                Handler.this.areaStack.push(text);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), TextMaker.class$org$apache$fop$area$inline$TextArea == null ? (TextMaker.class$org$apache$fop$area$inline$TextArea = TextMaker.class$("org.apache.fop.area.inline.TextArea")) : TextMaker.class$org$apache$fop$area$inline$TextArea);
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        }

        private class InlineBlockParentMaker
        extends AbstractMaker {
            static /* synthetic */ Class class$org$apache$fop$area$inline$InlineBlockParent;

            private InlineBlockParentMaker() {
            }

            public void startElement(Attributes attributes) {
                InlineBlockParent ibp = new InlineBlockParent();
                ibp.setOffset(Handler.this.getAttributeAsInteger(attributes, "offset", 0));
                Handler.this.setAreaAttributes(attributes, ibp);
                Handler.this.setTraits(attributes, ibp, SUBSET_COMMON);
                Handler.this.setTraits(attributes, ibp, SUBSET_BOX);
                Handler.this.setTraits(attributes, ibp, SUBSET_COLOR);
                Area parent = (Area)Handler.this.areaStack.peek();
                parent.addChildArea(ibp);
                Handler.this.areaStack.push(ibp);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), InlineBlockParentMaker.class$org$apache$fop$area$inline$InlineBlockParent == null ? (InlineBlockParentMaker.class$org$apache$fop$area$inline$InlineBlockParent = InlineBlockParentMaker.class$("org.apache.fop.area.inline.InlineBlockParent")) : InlineBlockParentMaker.class$org$apache$fop$area$inline$InlineBlockParent);
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        }

        private class InlineParentMaker
        extends AbstractMaker {
            static /* synthetic */ Class class$org$apache$fop$area$inline$InlineParent;

            private InlineParentMaker() {
            }

            public void startElement(Attributes attributes) {
                InlineParent ip = new InlineParent();
                ip.setOffset(Handler.this.getAttributeAsInteger(attributes, "offset", 0));
                Handler.this.setAreaAttributes(attributes, ip);
                Handler.this.setTraits(attributes, ip, SUBSET_COMMON);
                Handler.this.setTraits(attributes, ip, SUBSET_BOX);
                Handler.this.setTraits(attributes, ip, SUBSET_COLOR);
                Handler.this.setTraits(attributes, ip, SUBSET_LINK);
                Area parent = (Area)Handler.this.areaStack.peek();
                parent.addChildArea(ip);
                Handler.this.areaStack.push(ip);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), InlineParentMaker.class$org$apache$fop$area$inline$InlineParent == null ? (InlineParentMaker.class$org$apache$fop$area$inline$InlineParent = InlineParentMaker.class$("org.apache.fop.area.inline.InlineParent")) : InlineParentMaker.class$org$apache$fop$area$inline$InlineParent);
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        }

        private class LineAreaMaker
        extends AbstractMaker {
            static /* synthetic */ Class class$org$apache$fop$area$LineArea;

            private LineAreaMaker() {
            }

            public void startElement(Attributes attributes) {
                LineArea line = new LineArea();
                Handler.this.setAreaAttributes(attributes, line);
                Handler.this.setTraits(attributes, line, SUBSET_COMMON);
                Handler.this.setTraits(attributes, line, SUBSET_BOX);
                Handler.this.setTraits(attributes, line, SUBSET_COLOR);
                BlockParent parent = Handler.this.getCurrentBlockParent();
                parent.addChildArea(line);
                Handler.this.areaStack.push(line);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), LineAreaMaker.class$org$apache$fop$area$LineArea == null ? (LineAreaMaker.class$org$apache$fop$area$LineArea = LineAreaMaker.class$("org.apache.fop.area.LineArea")) : LineAreaMaker.class$org$apache$fop$area$LineArea);
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        }

        private class BlockMaker
        extends AbstractMaker {
            static /* synthetic */ Class class$org$apache$fop$area$Block;

            private BlockMaker() {
            }

            public void startElement(Attributes attributes) {
                Block block;
                boolean isViewport = Handler.this.getAttributeAsBoolean(attributes, "is-viewport-area", false);
                if (isViewport) {
                    BlockViewport bv = new BlockViewport();
                    bv.setClip(Handler.this.getAttributeAsBoolean(attributes, "clipped", false));
                    bv.setCTM(Handler.this.getAttributeAsCTM(attributes, "ctm"));
                    if (bv.getPositioning() != 1) {
                        bv.setXOffset(Handler.this.getAttributeAsInteger(attributes, "left-position", 0));
                        bv.setYOffset(Handler.this.getAttributeAsInteger(attributes, "top-position", 0));
                    }
                    block = bv;
                } else {
                    block = new Block();
                }
                String positioning = attributes.getValue("positioning");
                if ("absolute".equalsIgnoreCase(positioning)) {
                    block.setPositioning(2);
                } else if ("fixed".equalsIgnoreCase(positioning)) {
                    block.setPositioning(3);
                } else if ("relative".equalsIgnoreCase(positioning)) {
                    block.setPositioning(1);
                } else {
                    block.setPositioning(0);
                }
                if (attributes.getValue("left-offset") != null) {
                    block.setXOffset(Handler.this.getAttributeAsInteger(attributes, "left-offset", 0));
                }
                if (attributes.getValue("top-offset") != null) {
                    block.setYOffset(Handler.this.getAttributeAsInteger(attributes, "top-offset", 0));
                }
                Handler.this.setAreaAttributes(attributes, block);
                Handler.this.setTraits(attributes, block, SUBSET_COMMON);
                Handler.this.setTraits(attributes, block, SUBSET_BOX);
                Handler.this.setTraits(attributes, block, SUBSET_COLOR);
                Area parent = (Area)Handler.this.areaStack.peek();
                parent.addChildArea(block);
                Handler.this.areaStack.push(block);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), BlockMaker.class$org$apache$fop$area$Block == null ? (BlockMaker.class$org$apache$fop$area$Block = BlockMaker.class$("org.apache.fop.area.Block")) : BlockMaker.class$org$apache$fop$area$Block);
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        }

        private class BeforeFloatMaker
        extends AbstractMaker {
            static /* synthetic */ Class class$org$apache$fop$area$BeforeFloat;

            private BeforeFloatMaker() {
            }

            public void startElement(Attributes attributes) {
                Handler.this.areaStack.push(Handler.this.getCurrentBodyRegion().getBeforeFloat());
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), BeforeFloatMaker.class$org$apache$fop$area$BeforeFloat == null ? (BeforeFloatMaker.class$org$apache$fop$area$BeforeFloat = BeforeFloatMaker.class$("org.apache.fop.area.BeforeFloat")) : BeforeFloatMaker.class$org$apache$fop$area$BeforeFloat);
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        }

        private class FootnoteMaker
        extends AbstractMaker {
            static /* synthetic */ Class class$org$apache$fop$area$Footnote;

            private FootnoteMaker() {
            }

            public void startElement(Attributes attributes) {
                Handler.this.areaStack.push(Handler.this.getCurrentBodyRegion().getFootnote());
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), FootnoteMaker.class$org$apache$fop$area$Footnote == null ? (FootnoteMaker.class$org$apache$fop$area$Footnote = FootnoteMaker.class$("org.apache.fop.area.Footnote")) : FootnoteMaker.class$org$apache$fop$area$Footnote);
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        }

        private class SpanMaker
        extends AbstractMaker {
            private SpanMaker() {
            }

            public void startElement(Attributes attributes) {
                int ipd = Handler.this.getAttributeAsInteger(attributes, "ipd", 0);
                int columnCount = Handler.this.getAttributeAsInteger(attributes, "columnCount", 1);
                BodyRegion body = Handler.this.getCurrentBodyRegion();
                Span span = new Span(columnCount, body.getColumnGap(), ipd);
                Handler.this.setAreaAttributes(attributes, span);
                body.getMainReference().getSpans().add(span);
                Handler.this.firstFlow = true;
            }
        }

        private class MainReferenceMaker
        extends AbstractMaker {
            private MainReferenceMaker() {
            }

            public void startElement(Attributes attributes) {
                Handler.this.setAreaAttributes(attributes, Handler.this.getCurrentBodyRegion().getMainReference());
            }
        }

        private class FlowMaker
        extends AbstractMaker {
            static /* synthetic */ Class class$org$apache$fop$area$NormalFlow;

            private FlowMaker() {
            }

            public void startElement(Attributes attributes) {
                BodyRegion body = Handler.this.getCurrentBodyRegion();
                if (!Handler.this.firstFlow) {
                    body.getMainReference().getCurrentSpan().moveToNextFlow();
                } else {
                    Handler.this.firstFlow = false;
                }
                NormalFlow flow = body.getMainReference().getCurrentSpan().getCurrentFlow();
                Handler.this.setAreaAttributes(attributes, flow);
                Handler.this.areaStack.push(flow);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), FlowMaker.class$org$apache$fop$area$NormalFlow == null ? (FlowMaker.class$org$apache$fop$area$NormalFlow = FlowMaker.class$("org.apache.fop.area.NormalFlow")) : FlowMaker.class$org$apache$fop$area$NormalFlow);
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        }

        private class RegionBodyMaker
        extends AbstractMaker {
            static /* synthetic */ Class class$org$apache$fop$area$BodyRegion;

            private RegionBodyMaker() {
            }

            public void startElement(Attributes attributes) {
                BodyRegion body = Handler.this.getCurrentBodyRegion();
                if (body != null) {
                    throw new IllegalStateException("Current BodyRegion must be null");
                }
                String regionName = attributes.getValue("name");
                int columnCount = Handler.this.getAttributeAsInteger(attributes, "columnCount", 1);
                int columnGap = Handler.this.getAttributeAsInteger(attributes, "columnGap", 0);
                RegionViewport rv = Handler.this.getCurrentRegionViewport();
                body = new BodyRegion(36, regionName, rv, columnCount, columnGap);
                body.setCTM(Handler.this.getAttributeAsCTM(attributes, "ctm"));
                Handler.this.setAreaAttributes(attributes, body);
                rv.setRegionReference(body);
                Handler.this.currentPageViewport.getPage().setRegionViewport(36, rv);
                Handler.this.areaStack.push(body);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), RegionBodyMaker.class$org$apache$fop$area$BodyRegion == null ? (RegionBodyMaker.class$org$apache$fop$area$BodyRegion = RegionBodyMaker.class$("org.apache.fop.area.BodyRegion")) : RegionBodyMaker.class$org$apache$fop$area$BodyRegion);
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        }

        private class RegionEndMaker
        extends AbstractMaker {
            static /* synthetic */ Class class$org$apache$fop$area$RegionReference;

            private RegionEndMaker() {
            }

            public void startElement(Attributes attributes) {
                Handler.this.pushNewRegionReference(attributes, 37);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), RegionEndMaker.class$org$apache$fop$area$RegionReference == null ? (RegionEndMaker.class$org$apache$fop$area$RegionReference = RegionEndMaker.class$("org.apache.fop.area.RegionReference")) : RegionEndMaker.class$org$apache$fop$area$RegionReference);
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        }

        private class RegionStartMaker
        extends AbstractMaker {
            static /* synthetic */ Class class$org$apache$fop$area$RegionReference;

            private RegionStartMaker() {
            }

            public void startElement(Attributes attributes) {
                Handler.this.pushNewRegionReference(attributes, 38);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), RegionStartMaker.class$org$apache$fop$area$RegionReference == null ? (RegionStartMaker.class$org$apache$fop$area$RegionReference = RegionStartMaker.class$("org.apache.fop.area.RegionReference")) : RegionStartMaker.class$org$apache$fop$area$RegionReference);
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        }

        private class RegionAfterMaker
        extends AbstractMaker {
            static /* synthetic */ Class class$org$apache$fop$area$RegionReference;

            private RegionAfterMaker() {
            }

            public void startElement(Attributes attributes) {
                Handler.this.pushNewRegionReference(attributes, 34);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), RegionAfterMaker.class$org$apache$fop$area$RegionReference == null ? (RegionAfterMaker.class$org$apache$fop$area$RegionReference = RegionAfterMaker.class$("org.apache.fop.area.RegionReference")) : RegionAfterMaker.class$org$apache$fop$area$RegionReference);
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        }

        private class RegionBeforeMaker
        extends AbstractMaker {
            static /* synthetic */ Class class$org$apache$fop$area$RegionReference;

            private RegionBeforeMaker() {
            }

            public void startElement(Attributes attributes) {
                Handler.this.pushNewRegionReference(attributes, 35);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), RegionBeforeMaker.class$org$apache$fop$area$RegionReference == null ? (RegionBeforeMaker.class$org$apache$fop$area$RegionReference = RegionBeforeMaker.class$("org.apache.fop.area.RegionReference")) : RegionBeforeMaker.class$org$apache$fop$area$RegionReference);
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        }

        private class RegionViewportMaker
        extends AbstractMaker {
            static /* synthetic */ Class class$org$apache$fop$area$RegionViewport;

            private RegionViewportMaker() {
            }

            public void startElement(Attributes attributes) {
                RegionViewport rv = Handler.this.getCurrentRegionViewport();
                if (rv != null) {
                    throw new IllegalStateException("Current RegionViewport must be null");
                }
                Rectangle2D viewArea = Handler.parseRect(attributes.getValue("rect"));
                rv = new RegionViewport(viewArea);
                rv.setClip(Handler.this.getAttributeAsBoolean(attributes, "clipped", false));
                Handler.this.setAreaAttributes(attributes, rv);
                Handler.this.setTraits(attributes, rv, SUBSET_COMMON);
                Handler.this.setTraits(attributes, rv, SUBSET_BOX);
                Handler.this.setTraits(attributes, rv, SUBSET_COLOR);
                Handler.this.areaStack.push(rv);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), RegionViewportMaker.class$org$apache$fop$area$RegionViewport == null ? (RegionViewportMaker.class$org$apache$fop$area$RegionViewport = RegionViewportMaker.class$("org.apache.fop.area.RegionViewport")) : RegionViewportMaker.class$org$apache$fop$area$RegionViewport);
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        }

        private class PageMaker
        extends AbstractMaker {
            private PageMaker() {
            }

            public void startElement(Attributes attributes) {
                Page p = new Page();
                Handler.this.currentPageViewport.setPage(p);
            }

            public void endElement() {
                Handler.this.treeModel.addPage(Handler.this.currentPageViewport);
                Handler.this.currentPageViewport = null;
            }
        }

        private class PageViewportMaker
        extends AbstractMaker {
            private PageViewportMaker() {
            }

            public void startElement(Attributes attributes) {
                if (Handler.this.pendingStartPageSequence) {
                    Handler.this.treeModel.startPageSequence(null);
                    Handler.this.pendingStartPageSequence = false;
                }
                if (Handler.this.currentPageViewport != null) {
                    throw new IllegalStateException("currentPageViewport must be null");
                }
                Rectangle2D viewArea = Handler.parseRect(attributes.getValue("bounds"));
                int pageNumber = Handler.this.getAttributeAsInteger(attributes, "nr", -1);
                String pageNumberString = attributes.getValue("formatted-nr");
                String pageMaster = attributes.getValue("simple-page-master-name");
                boolean blank = Handler.this.getAttributeAsBoolean(attributes, "blank", false);
                Handler.this.currentPageViewport = new PageViewport(viewArea, pageNumber, pageNumberString, pageMaster, blank);
            }
        }

        private class TitleMaker
        extends AbstractMaker {
            private TitleMaker() {
            }

            public void startElement(Attributes attributes) {
                LineArea line = new LineArea();
                Handler.this.areaStack.push(line);
            }

            public void endElement() {
                LineArea line = (LineArea)Handler.this.areaStack.pop();
                Handler.this.treeModel.startPageSequence(line);
                Handler.this.pendingStartPageSequence = false;
            }
        }

        private class PageSequenceMaker
        extends AbstractMaker {
            private PageSequenceMaker() {
            }

            public void startElement(Attributes attributes) {
                Handler.this.pendingStartPageSequence = true;
            }
        }

        private class AreaTreeMaker
        extends AbstractMaker {
            private AreaTreeMaker() {
            }
        }

        private abstract class AbstractMaker
        implements Maker {
            private AbstractMaker() {
            }

            public void startElement(Attributes attributes) throws SAXException {
            }

            public void endElement() {
            }
        }

        private static interface Maker {
            public void startElement(Attributes var1) throws SAXException;

            public void endElement();
        }
    }
}

