/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.AreaTreeModel;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.RenderPagesModel;
import org.apache.fop.fonts.FontInfo;
import org.xml.sax.SAXException;

public class CachedRenderPagesModel
extends RenderPagesModel {
    private Map pageMap = new HashMap();
    protected File baseDir = new File(System.getProperty("java.io.tmpdir"));

    public CachedRenderPagesModel(FOUserAgent userAgent, String outputFormat, FontInfo fontInfo, OutputStream stream) throws FOPException {
        super(userAgent, outputFormat, fontInfo, stream);
    }

    protected boolean checkPreparedPages(PageViewport newpage, boolean renderUnresolved) {
        Iterator iter = this.prepared.iterator();
        while (iter.hasNext()) {
            PageViewport p = (PageViewport)iter.next();
            if (p.isResolved() || renderUnresolved) {
                if (p != newpage) {
                    try {
                        Object var9_11;
                        String name = (String)this.pageMap.get(p);
                        File tempFile = new File(this.baseDir, name);
                        AreaTreeModel.log.debug("Loading page from: " + tempFile);
                        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(tempFile)));
                        try {
                            p.loadPage(in);
                            var9_11 = null;
                        }
                        catch (Throwable throwable) {
                            var9_11 = null;
                            IOUtils.closeQuietly(in);
                            throw throwable;
                        }
                        IOUtils.closeQuietly(in);
                        if (!tempFile.delete()) {
                            AreaTreeModel.log.warn("Temporary file could not be deleted: " + tempFile);
                        }
                        this.pageMap.remove(p);
                    }
                    catch (Exception e) {
                        AreaTreeModel.log.error(e);
                    }
                }
                try {
                    this.renderer.renderPage(p);
                    if (!p.isResolved()) {
                        String[] idrefs = p.getIDRefs();
                        int count = 0;
                        while (count < idrefs.length) {
                            AreaTreeModel.log.warn("Page " + p.getPageNumberString() + ": Unresolved id reference \"" + idrefs[count] + "\" found.");
                            ++count;
                        }
                    }
                }
                catch (Exception e) {
                    AreaTreeModel.log.error(e);
                }
                p.clear();
                iter.remove();
                continue;
            }
            if (this.renderer.supportsOutOfOrder()) continue;
        }
        if (newpage != null && newpage.getPage() != null) {
            this.savePage(newpage);
            newpage.clear();
        }
        return this.renderer.supportsOutOfOrder() || this.prepared.isEmpty();
    }

    protected void savePage(PageViewport page) {
        try {
            String fname = "fop-page-" + page.toString() + ".ser";
            File tempFile = new File(this.baseDir, fname);
            tempFile.deleteOnExit();
            ObjectOutputStream tempstream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(tempFile)));
            try {
                page.savePage(tempstream);
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                IOUtils.closeQuietly(tempstream);
                throw throwable;
            }
            IOUtils.closeQuietly(tempstream);
            this.pageMap.put(page, fname);
            if (AreaTreeModel.log.isDebugEnabled()) {
                AreaTreeModel.log.debug("Page saved to temporary file: " + tempFile);
            }
        }
        catch (Exception e) {
            AreaTreeModel.log.error(e);
        }
    }

    public void endDocument() throws SAXException {
        super.endDocument();
    }
}

