/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.cli;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.cli.CommandLineOptions;

public class Main {
    static /* synthetic */ Class array$Ljava$lang$String;

    public static URL[] getJARList() throws MalformedURLException {
        String optionalLib;
        File[] files;
        File buildDir;
        File baseDir = new File(".").getAbsoluteFile().getParentFile();
        if ("build".equals(baseDir.getName())) {
            buildDir = baseDir;
            baseDir = baseDir.getParentFile();
        } else {
            buildDir = new File(baseDir, "build");
        }
        File fopJar = new File(buildDir, "fop.jar");
        if (!fopJar.exists()) {
            fopJar = new File(baseDir, "fop.jar");
        }
        if (!fopJar.exists()) {
            throw new RuntimeException("fop.jar not found in directory: " + baseDir.getAbsolutePath() + " (or below)");
        }
        ArrayList<URL> jars = new ArrayList<URL>();
        jars.add(fopJar.toURL());
        FileFilter filter = new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".jar");
            }
        };
        File libDir = new File(baseDir, "lib");
        if (!libDir.exists()) {
            libDir = baseDir;
        }
        if ((files = libDir.listFiles(filter)) != null) {
            int i = 0;
            int size = files.length;
            while (i < size) {
                jars.add(files[i].toURL());
                ++i;
            }
        }
        if ((optionalLib = System.getProperty("fop.optional.lib")) != null && (files = new File(optionalLib).listFiles(filter)) != null) {
            int i = 0;
            int size = files.length;
            while (i < size) {
                jars.add(files[i].toURL());
                ++i;
            }
        }
        URL[] urls = jars.toArray(new URL[jars.size()]);
        return urls;
    }

    public static boolean checkDependencies() {
        try {
            Class<?> clazz = Class.forName("org.apache.commons.io.IOUtils");
            if (clazz != null) {
                clazz = Class.forName("org.apache.avalon.framework.configuration.Configuration");
            }
            return clazz != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void startFOPWithDynamicClasspath(String[] args) {
        try {
            URL[] urls = Main.getJARList();
            URLClassLoader loader = new URLClassLoader(urls, null);
            Thread.currentThread().setContextClassLoader(loader);
            Class<?> clazz = Class.forName("org.apache.fop.cli.Main", true, loader);
            Method mainMethod = clazz.getMethod("startFOP", array$Ljava$lang$String == null ? (array$Ljava$lang$String = Main.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
            mainMethod.invoke(null, new Object[]{args});
        }
        catch (Exception e) {
            System.err.println("Unable to start FOP:");
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static void startFOP(String[] args) {
        CommandLineOptions options = null;
        FOUserAgent foUserAgent = null;
        BufferedOutputStream out = null;
        try {
            options = new CommandLineOptions();
            options.parse(args);
            foUserAgent = options.getFOUserAgent();
            String outputFormat = options.getOutputFormat();
            try {
                if (options.getOutputFile() != null) {
                    out = new BufferedOutputStream(new FileOutputStream(options.getOutputFile()));
                    foUserAgent.setOutputFile(options.getOutputFile());
                }
                if (!"text/xsl".equals(outputFormat)) {
                    options.getInputHandler().renderTo(foUserAgent, outputFormat, out);
                } else {
                    options.getInputHandler().transformTo(out);
                }
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly(out);
            if (!"application/X-fop-awt-preview".equals(outputFormat)) {
                System.exit(0);
            }
        }
        catch (Exception e) {
            if (options != null) {
                options.getLogger().error("Exception", e);
            }
            if (options.getOutputFile() != null) {
                options.getOutputFile().delete();
            }
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        if (Main.checkDependencies()) {
            Main.startFOP(args);
        } else {
            Main.startFOPWithDynamicClasspath(args);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

