/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.properties.CommonAccessibility;
import org.apache.fop.fo.properties.CommonAural;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonRelativePosition;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.fo.properties.LengthRangeProperty;
import org.xml.sax.Locator;

public class TableCaption
extends FObj {
    private CommonAccessibility commonAccessibility;
    private CommonAural commonAural;
    private CommonBorderPaddingBackground commonBorderPaddingBackground;
    private CommonRelativePosition commonRelativePosition;
    private LengthRangeProperty blockProgressionDimension;
    private Length height;
    private String id;
    private LengthRangeProperty inlineProgressionDimension;
    private int intrusionDisplace;
    private KeepProperty keepTogether;
    private Length width;
    private boolean blockItemFound = false;
    static boolean notImplementedWarningGiven = false;

    public TableCaption(FONode parent) {
        super(parent);
        if (!notImplementedWarningGiven) {
            this.getLogger().warn("fo:table-caption is not yet implemented.");
            notImplementedWarningGiven = true;
        }
    }

    public void bind(PropertyList pList) throws FOPException {
        this.commonAccessibility = pList.getAccessibilityProps();
        this.commonAural = pList.getAuralProps();
        this.commonBorderPaddingBackground = pList.getBorderPaddingBackgroundProps();
        this.commonRelativePosition = pList.getRelativePositionProps();
        this.blockProgressionDimension = pList.get(17).getLengthRange();
        this.height = pList.get(106).getLength();
        this.id = pList.get(113).getString();
        this.inlineProgressionDimension = pList.get(116).getLengthRange();
        this.intrusionDisplace = pList.get(248).getEnum();
        this.keepTogether = pList.get(118).getKeep();
        this.width = pList.get(242).getLength();
    }

    protected void startOfNode() throws FOPException {
        this.checkId(this.id);
    }

    protected void endOfNode() throws FOPException {
        if (this.childNodes == null) {
            this.missingChildElementError("marker* (%block;)");
        }
    }

    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(nsURI) && localName.equals("marker")) {
            if (this.blockItemFound) {
                this.nodesOutOfOrderError(loc, "fo:marker", "(%block;)");
            }
        } else if (!this.isBlockItem(nsURI, localName)) {
            this.invalidChildError(loc, nsURI, localName);
        } else {
            this.blockItemFound = true;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getLocalName() {
        return "table-caption";
    }

    public int getNameId() {
        return 49;
    }
}

