/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.StaticPropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.flow.TableFObj;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.Property;
import org.xml.sax.Locator;

public class TableColumn
extends TableFObj {
    private CommonBorderPaddingBackground commonBorderPaddingBackground;
    private Numeric columnNumber;
    private Length columnWidth;
    private Numeric numberColumnsRepeated;
    private Numeric numberColumnsSpanned;
    private int visibility;
    private boolean defaultColumn;
    private StaticPropertyList pList = null;

    public TableColumn(FONode parent) {
        this(parent, false);
    }

    public TableColumn(FONode parent, boolean defaultColumn) {
        super(parent);
        this.defaultColumn = defaultColumn;
    }

    public void bind(PropertyList pList) throws FOPException {
        this.commonBorderPaddingBackground = pList.getBorderPaddingBackgroundProps();
        this.columnNumber = pList.get(70).getNumeric();
        this.columnWidth = pList.get(71).getLength();
        this.numberColumnsRepeated = pList.get(148).getNumeric();
        this.numberColumnsSpanned = pList.get(149).getNumeric();
        this.visibility = pList.get(235).getEnum();
        super.bind(pList);
        if (this.getTable().isColumnNumberUsed(this.columnNumber.getValue())) {
            throw new PropertyException("column-number \"" + this.columnNumber + "\" has already been assigned to a previous column");
        }
        if (this.numberColumnsRepeated.getValue() <= 0) {
            throw new PropertyException("number-columns-repeated must be 1 or bigger, but got " + this.numberColumnsRepeated.getValue());
        }
        if (this.numberColumnsSpanned.getValue() <= 0) {
            throw new PropertyException("number-columns-spanned must be 1 or bigger, but got " + this.numberColumnsSpanned.getValue());
        }
        this.pList = new StaticPropertyList(this, pList);
    }

    protected void startOfNode() throws FOPException {
        this.getFOEventHandler().startColumn(this);
    }

    protected void endOfNode() throws FOPException {
        this.getFOEventHandler().endColumn(this);
    }

    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        this.invalidChildError(loc, nsURI, localName);
    }

    public CommonBorderPaddingBackground getCommonBorderPaddingBackground() {
        return this.commonBorderPaddingBackground;
    }

    public Length getColumnWidth() {
        return this.columnWidth;
    }

    public void setColumnWidth(Length columnWidth) {
        this.columnWidth = columnWidth;
    }

    public int getColumnNumber() {
        return this.columnNumber.getValue();
    }

    public int getNumberColumnsRepeated() {
        return this.numberColumnsRepeated.getValue();
    }

    public int getNumberColumnsSpanned() {
        return this.numberColumnsSpanned.getValue();
    }

    public String getLocalName() {
        return "table-column";
    }

    public int getNameId() {
        return 51;
    }

    public boolean isDefaultColumn() {
        return this.defaultColumn;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("fo:table-column");
        sb.append(" column-number=").append(this.getColumnNumber());
        if (this.getNumberColumnsRepeated() > 1) {
            sb.append(" number-columns-repeated=").append(this.getNumberColumnsRepeated());
        }
        if (this.getNumberColumnsSpanned() > 1) {
            sb.append(" number-columns-spanned=").append(this.getNumberColumnsSpanned());
        }
        sb.append(" column-width=").append(this.getColumnWidth());
        return sb.toString();
    }

    public Property getProperty(int propId) throws PropertyException {
        return this.pList.getInherited(propId);
    }

    protected void releasePropertyList() {
        this.pList = null;
    }
}

