/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.xml.sax.Locator;

public class ColorProfile
extends FObj {
    private String src;
    private String colorProfileName;
    private int renderingIntent;
    private ICC_ColorSpace colorSpace = null;

    public ColorProfile(FONode parent) {
        super(parent);
    }

    public void bind(PropertyList pList) throws FOPException {
        this.src = pList.get(210).getString();
        this.colorProfileName = pList.get(67).getString();
        this.renderingIntent = pList.get(184).getEnum();
    }

    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        this.invalidChildError(loc, nsURI, localName);
    }

    public String getColorProfileName() {
        return this.colorProfileName;
    }

    public ColorType getColor(int[] colorVals, int defR, int defG, int defB) {
        return null;
    }

    private void load() {
        try {
            URL url = new URL(this.src);
            InputStream is = url.openStream();
            ICC_Profile iccProfile = ICC_Profile.getInstance(is);
            this.colorSpace = new ICC_ColorSpace(iccProfile);
        }
        catch (IOException ioe) {
            this.getLogger().error("Could not read Color Profile src", ioe);
        }
        catch (IllegalArgumentException iae) {
            this.getLogger().error("Color Profile src not an ICC Profile", iae);
        }
    }

    public String getLocalName() {
        return "color-profile";
    }

    public int getNameId() {
        return 6;
    }
}

