/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import java.util.List;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;

public class CommonFont {
    private String[] fontFamily;
    public int fontSelectionStrategy;
    public Length fontSize;
    public int fontStretch;
    public Numeric fontSizeAdjust;
    public int fontStyle;
    public int fontVariant;
    public int fontWeight;
    private Font fontState;

    public CommonFont(PropertyList pList) throws PropertyException {
        List lst = pList.get(92).getList();
        this.fontFamily = new String[lst.size()];
        int i = 0;
        int c = lst.size();
        while (i < c) {
            this.fontFamily[i] = ((Property)lst.get(i)).getString();
            ++i;
        }
        if (this.fontFamily.length == 0) {
            this.fontFamily = new String[]{"any"};
        }
        this.fontSelectionStrategy = pList.get(93).getEnum();
        this.fontSize = pList.get(94).getLength();
        this.fontStretch = pList.get(96).getEnum();
        this.fontSizeAdjust = pList.get(95).getNumeric();
        this.fontStyle = pList.get(97).getEnum();
        this.fontVariant = pList.get(98).getEnum();
        this.fontWeight = pList.get(99).getEnum();
    }

    public String getFirstFontFamily() {
        return this.fontFamily[0];
    }

    public String[] getFontFamily() {
        return this.fontFamily;
    }

    public void overrideFontFamily(String value) {
        this.fontFamily = new String[]{value};
    }

    public Font getFontState(FontInfo fontInfo, PercentBaseContext context) {
        if (this.fontState == null) {
            String style;
            int font_weight = 400;
            if (this.fontWeight != 167 && this.fontWeight != 168) {
                switch (this.fontWeight) {
                    case 168: {
                        font_weight = 100;
                        break;
                    }
                    case 169: {
                        font_weight = 200;
                        break;
                    }
                    case 170: {
                        font_weight = 300;
                        break;
                    }
                    case 171: {
                        font_weight = 400;
                        break;
                    }
                    case 172: {
                        font_weight = 500;
                        break;
                    }
                    case 173: {
                        font_weight = 600;
                        break;
                    }
                    case 174: {
                        font_weight = 700;
                        break;
                    }
                    case 175: {
                        font_weight = 800;
                        break;
                    }
                    case 176: {
                        font_weight = 900;
                    }
                }
            }
            switch (this.fontStyle) {
                case 164: {
                    style = "italic";
                    break;
                }
                case 165: {
                    style = "oblique";
                    break;
                }
                case 166: {
                    style = "backslant";
                    break;
                }
                default: {
                    style = "normal";
                }
            }
            FontTriplet triplet = fontInfo.fontLookup(this.getFontFamily(), style, font_weight);
            this.fontState = fontInfo.getFontInstance(triplet, this.fontSize.getValue(context));
        }
        return this.fontState;
    }
}

