/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.fo.Constants;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.EnumProperty;
import org.apache.fop.fo.properties.Property;

public class FontStretchPropertyMaker
extends EnumProperty.Maker
implements Constants {
    private Property[] orderedFontStretchValues = null;

    public FontStretchPropertyMaker(int propId) {
        super(propId);
    }

    public Property convertProperty(Property p, PropertyList propertyList, FObj fo) throws PropertyException {
        if (p.getEnum() == 85) {
            return this.computeNextAbsoluteFontStretch(propertyList.getFromParent(this.getPropId()), -1);
        }
        if (p.getEnum() == 160) {
            return this.computeNextAbsoluteFontStretch(propertyList.getFromParent(this.getPropId()), 1);
        }
        return super.convertProperty(p, propertyList, fo);
    }

    private Property computeNextAbsoluteFontStretch(Property baseProperty, int direction) {
        if (this.orderedFontStretchValues == null) {
            this.orderedFontStretchValues = new Property[]{this.checkEnumValues("ultra-condensed"), this.checkEnumValues("extra-condensed"), this.checkEnumValues("condensed"), this.checkEnumValues("semi-condensed"), this.checkEnumValues("normal"), this.checkEnumValues("semi-expanded"), this.checkEnumValues("expanded"), this.checkEnumValues("extra-expanded"), this.checkEnumValues("ultra-expanded")};
        }
        int baseValue = baseProperty.getEnum();
        int i = 0;
        while (i < this.orderedFontStretchValues.length) {
            if (baseValue == this.orderedFontStretchValues[i].getEnum()) {
                i = Math.min(Math.max(0, i + direction), this.orderedFontStretchValues.length - 1);
                return this.orderedFontStretchValues[i];
            }
            ++i;
        }
        return this.orderedFontStretchValues[4];
    }
}

