/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontMetrics;
import org.apache.fop.fonts.FontTriplet;

public class FontInfo {
    protected static Log log = LogFactory.getLog(class$org$apache$fop$fonts$FontInfo == null ? (class$org$apache$fop$fonts$FontInfo = FontInfo.class$("org.apache.fop.fonts.FontInfo")) : class$org$apache$fop$fonts$FontInfo);
    private Map usedFonts;
    private Map triplets;
    private Map fonts;
    private Collection loggedFontKeys;
    private Map fontInstanceCache = new HashMap();
    static /* synthetic */ Class class$org$apache$fop$fonts$FontInfo;

    public FontInfo() {
        this.triplets = new HashMap();
        this.fonts = new HashMap();
        this.usedFonts = new HashMap();
    }

    public boolean isSetupValid() {
        return this.triplets.containsKey(Font.DEFAULT_FONT);
    }

    public void addFontProperties(String name, String family, String style, int weight) {
        this.addFontProperties(name, FontInfo.createFontKey(family, style, weight));
    }

    public void addFontProperties(String name, FontTriplet triplet) {
        this.triplets.put(triplet, name);
    }

    public void addMetrics(String name, FontMetrics metrics) {
        this.fonts.put(name, metrics);
    }

    private FontTriplet fontLookup(String family, String style, int weight, boolean substFont) {
        FontTriplet startKey = FontInfo.createFontKey(family, style, weight);
        FontTriplet key = startKey;
        String f = this.getInternalFontKey(key);
        if (f == null) {
            key = this.findAdjustWeight(family, style, weight);
            f = this.getInternalFontKey(key);
            if (!substFont && f == null) {
                return null;
            }
            if (f == null) {
                this.notifyFontReplacement(startKey);
                key = FontInfo.createFontKey("any", style, weight);
                f = this.getInternalFontKey(key);
            }
            if (f == null) {
                key = Font.DEFAULT_FONT;
                f = this.getInternalFontKey(key);
            }
        }
        if (f != null) {
            return key;
        }
        return null;
    }

    public void useFont(String internalName) {
        this.usedFonts.put(internalName, this.fonts.get(internalName));
    }

    public Font getFontInstance(FontTriplet triplet, int fontSize) {
        Integer size;
        Font font;
        HashMap<Integer, Font> sizes = (HashMap<Integer, Font>)this.fontInstanceCache.get(triplet);
        if (sizes == null) {
            sizes = new HashMap<Integer, Font>();
            this.fontInstanceCache.put(triplet, sizes);
        }
        if ((font = (Font)sizes.get(size = new Integer(fontSize))) == null) {
            String fname = this.getInternalFontKey(triplet);
            this.useFont(fname);
            FontMetrics metrics = this.getMetricsFor(fname);
            font = new Font(fname, triplet, metrics, fontSize);
            sizes.put(size, font);
        }
        return font;
    }

    public FontTriplet fontLookup(String family, String style, int weight) {
        return this.fontLookup(family, style, weight, true);
    }

    public FontTriplet fontLookup(String[] family, String style, int weight) {
        int i = 0;
        while (i < family.length) {
            FontTriplet triplet = this.fontLookup(family[i], style, weight, i >= family.length - 1);
            if (triplet != null) {
                return triplet;
            }
            ++i;
        }
        throw new IllegalStateException("fontLookup must return a key on the last call");
    }

    private void notifyFontReplacement(FontTriplet key) {
        if (this.loggedFontKeys == null) {
            this.loggedFontKeys = new HashSet();
        }
        if (!this.loggedFontKeys.contains(key)) {
            this.loggedFontKeys.add(key);
            log.warn("Font '" + key + "' not found. Substituting with default font.");
        }
    }

    public FontTriplet findAdjustWeight(String family, String style, int weight) {
        FontTriplet key = null;
        String f = null;
        int newWeight = weight;
        if (newWeight < 400) {
            while (f == null && newWeight > 0) {
                key = FontInfo.createFontKey(family, style, newWeight -= 100);
                f = this.getInternalFontKey(key);
            }
        } else if (newWeight == 500) {
            key = FontInfo.createFontKey(family, style, 400);
            f = this.getInternalFontKey(key);
        } else if (newWeight > 500) {
            while (f == null && newWeight < 1000) {
                key = FontInfo.createFontKey(family, style, newWeight += 100);
                f = this.getInternalFontKey(key);
            }
            newWeight = weight;
            while (f == null && newWeight > 400) {
                key = FontInfo.createFontKey(family, style, newWeight -= 100);
                f = this.getInternalFontKey(key);
            }
        }
        if (f == null && weight != 400) {
            key = FontInfo.createFontKey(family, style, 400);
            f = this.getInternalFontKey(key);
        }
        if (f != null) {
            return key;
        }
        return null;
    }

    public boolean hasFont(String family, String style, int weight) {
        FontTriplet key = FontInfo.createFontKey(family, style, weight);
        return this.triplets.containsKey(key);
    }

    public String getInternalFontKey(FontTriplet triplet) {
        return (String)this.triplets.get(triplet);
    }

    public static FontTriplet createFontKey(String family, String style, int weight) {
        return new FontTriplet(family, style, weight);
    }

    public Map getFonts() {
        return Collections.unmodifiableMap(this.fonts);
    }

    public Map getUsedFonts() {
        return this.usedFonts;
    }

    public FontMetrics getMetricsFor(String fontName) {
        FontMetrics metrics = (FontMetrics)this.fonts.get(fontName);
        this.usedFonts.put(fontName, metrics);
        return metrics;
    }

    public FontTriplet getTripletFor(String fontName) {
        ArrayList foundTriplets = new ArrayList();
        Iterator iter = this.triplets.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry tripletEntry = iter.next();
            if (!fontName.equals((String)tripletEntry.getValue())) continue;
            foundTriplets.add(tripletEntry.getKey());
        }
        if (foundTriplets.size() > 0) {
            Collections.sort(foundTriplets);
            return (FontTriplet)foundTriplets.get(0);
        }
        return null;
    }

    public String getFontStyleFor(String fontName) {
        FontTriplet triplet = this.getTripletFor(fontName);
        if (triplet != null) {
            return triplet.getStyle();
        }
        return "";
    }

    public int getFontWeightFor(String fontName) {
        FontTriplet triplet = this.getTripletFor(fontName);
        if (triplet != null) {
            return triplet.getWeight();
        }
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

