/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image;

import java.awt.color.ColorSpace;
import java.io.IOException;
import org.apache.commons.io.IOUtils;
import org.apache.fop.image.AbstractFopImage;
import org.apache.fop.image.FopImage;

public class BmpImage
extends AbstractFopImage {
    public BmpImage(FopImage.ImageInfo imgInfo) {
        super(imgInfo);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean loadBitmap() {
        int count2;
        byte[] palette;
        int filepos;
        int[] headermap;
        int hpos;
        int wpos;
        block40: {
            wpos = 18;
            hpos = 22;
            headermap = new int[54];
            filepos = 0;
            palette = null;
            try {
                int countr;
                int palettesize;
                boolean eof = false;
                while (true) {
                    if (eof || filepos >= 54) {
                        if (headermap[28] == 4 || headermap[28] == 8) {
                            palettesize = 1 << headermap[28];
                            palette = new byte[palettesize * 3];
                            countr = 0;
                            break;
                        }
                        break block40;
                    }
                    int input = this.inputStream.read();
                    if (input == -1) {
                        eof = true;
                        continue;
                    }
                    headermap[filepos++] = input;
                }
                block7: while (!eof && countr < palettesize) {
                    count2 = 2;
                    while (true) {
                        if (eof || count2 < -1) {
                            ++countr;
                            continue block7;
                        }
                        int input = this.inputStream.read();
                        if (input == -1) {
                            eof = true;
                        } else if (count2 >= 0) {
                            palette[countr * 3 + count2] = (byte)(input & 0xFF);
                        }
                        --count2;
                        ++filepos;
                    }
                }
            }
            catch (IOException ex) {
                AbstractFopImage.log.error("Error while loading image (Bmp): " + ex.getMessage(), ex);
                IOUtils.closeQuietly(this.inputStream);
                this.inputStream = null;
                return false;
            }
        }
        this.width = headermap[wpos] + headermap[wpos + 1] * 256 + headermap[wpos + 2] * 256 * 256 + headermap[wpos + 3] * 256 * 256 * 256;
        this.height = headermap[hpos] + headermap[hpos + 1] * 256 + headermap[hpos + 2] * 256 * 256 + headermap[hpos + 3] * 256 * 256 * 256;
        int imagestart = headermap[10] + headermap[11] * 256 + headermap[12] * 256 * 256 + headermap[13] * 256 * 256 * 256;
        this.bitsPerPixel = headermap[28];
        this.colorSpace = ColorSpace.getInstance(1004);
        int bytes = 0;
        if (this.bitsPerPixel == 1) {
            bytes = (this.width + 7) / 8;
        } else if (this.bitsPerPixel == 24) {
            bytes = this.width * 3;
        } else {
            if (this.bitsPerPixel != 4 && this.bitsPerPixel != 8) {
                AbstractFopImage.log.error("Image () has " + this.bitsPerPixel + " which is not a supported BMP format.");
                return false;
            }
            bytes = this.width / (8 / this.bitsPerPixel);
        }
        if ((bytes & 3) != 0) {
            bytes |= 3;
            ++bytes;
        }
        this.bitmaps = new byte[this.width * this.height * 3];
        int[] temp = new int[bytes * this.height];
        try {
            boolean count;
            try {
                int input;
                count = false;
                this.inputStream.skip(imagestart - filepos);
                while ((input = this.inputStream.read()) != -1) {
                    if (count >= temp.length) {
                        AbstractFopImage.log.warn("Data longer than expected while loading image");
                        break;
                    }
                    temp[count++] = count2;
                }
            }
            catch (IOException ex) {
                AbstractFopImage.log.error("Error while loading image (Bmp): " + ex.getMessage(), ex);
                count = false;
                Object var12_15 = null;
                IOUtils.closeQuietly(this.inputStream);
                this.inputStream = null;
                return count;
            }
            Object var12_14 = null;
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            IOUtils.closeQuietly(this.inputStream);
            this.inputStream = null;
            throw throwable;
        }
        IOUtils.closeQuietly(this.inputStream);
        this.inputStream = null;
        int i = 0;
        block10: while (true) {
            if (i >= this.height) {
                this.bitsPerPixel = 8;
                return true;
            }
            int x = 0;
            int j = 0;
            block11: while (true) {
                int countr;
                if (j >= bytes) {
                    ++i;
                    continue block10;
                }
                int p = temp[(this.height - i - 1) * bytes + j];
                if (this.bitsPerPixel == 24 && x < this.width) {
                    countr = 2;
                    do {
                        this.bitmaps[3 * (i * this.width + x) + countr] = (byte)(temp[(this.height - i - 1) * bytes + j] & 0xFF);
                        ++j;
                    } while (--countr >= 0);
                    ++x;
                    continue;
                }
                if (this.bitsPerPixel == 1) {
                    countr = 0;
                    while (true) {
                        if (countr >= 8 || x >= this.width) {
                            ++j;
                            continue block11;
                        }
                        if ((p & 0x80) != 0) {
                            this.bitmaps[3 * (i * this.width + x)] = -1;
                            this.bitmaps[3 * (i * this.width + x) + 1] = -1;
                            this.bitmaps[3 * (i * this.width + x) + 2] = -1;
                        } else {
                            this.bitmaps[3 * (i * this.width + x)] = 0;
                            this.bitmaps[3 * (i * this.width + x) + 1] = 0;
                            this.bitmaps[3 * (i * this.width + x) + 2] = 0;
                        }
                        p <<= 1;
                        ++x;
                        ++countr;
                    }
                }
                if (this.bitsPerPixel == 4) {
                    countr = 0;
                    while (true) {
                        if (countr >= 2 || x >= this.width) {
                            ++j;
                            continue block11;
                        }
                        int pal = ((p & 0xF0) >> 4) * 3;
                        this.bitmaps[3 * (i * this.width + x)] = palette[pal];
                        this.bitmaps[3 * (i * this.width + x) + 1] = palette[pal + 1];
                        this.bitmaps[3 * (i * this.width + x) + 2] = palette[pal + 2];
                        p <<= 4;
                        ++x;
                        ++countr;
                    }
                }
                if (this.bitsPerPixel == 8) {
                    if (x < this.width) {
                        this.bitmaps[3 * (i * this.width + x)] = palette[p *= 3];
                        this.bitmaps[3 * (i * this.width + x) + 1] = palette[p + 1];
                        this.bitmaps[3 * (i * this.width + x) + 2] = palette[p + 2];
                        ++j;
                        ++x;
                        continue;
                    }
                    j = bytes;
                    continue;
                }
                ++j;
            }
            break;
        }
    }
}

