/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import org.apache.commons.io.IOUtils;
import org.apache.fop.image.AbstractFopImage;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.FopImageConsumer;

public class GifImage
extends AbstractFopImage {
    public GifImage(FopImage.ImageInfo imgInfo) {
        super(imgInfo);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean loadBitmap() {
        int[] tmpMap;
        block21: {
            boolean bl;
            block19: {
                tmpMap = null;
                try {
                    block20: {
                        try {
                            DummyConnection con = new DummyConnection(this.inputStream);
                            ImageProducer ip = (ImageProducer)con.getContent();
                            if (ip == null) {
                                bl = false;
                                Object var14_11 = null;
                                break block19;
                            }
                            FopImageConsumer consumer = new FopImageConsumer(ip);
                            ip.startProduction(consumer);
                            while (true) {
                                if (consumer.isImageReady()) {
                                    this.height = consumer.getHeight();
                                    this.width = consumer.getWidth();
                                    try {
                                        tmpMap = consumer.getImage();
                                        break;
                                    }
                                    catch (Exception ex) {
                                        AbstractFopImage.log.error("Image grabbing interrupted : " + ex.getMessage(), ex);
                                        boolean bl2 = false;
                                        Object var14_12 = null;
                                        IOUtils.closeQuietly(this.inputStream);
                                        this.inputStream = null;
                                        return bl2;
                                    }
                                }
                                Thread.sleep(500L);
                            }
                            ColorModel cm = consumer.getColorModel();
                            this.bitsPerPixel = 8;
                            this.colorSpace = ColorSpace.getInstance(1004);
                            if (cm.hasAlpha()) {
                                int transparencyType = cm.getTransparency();
                                if (transparencyType == 1) {
                                    this.isTransparent = false;
                                    break block20;
                                }
                                if (transparencyType == 2) {
                                    if (cm instanceof IndexColorModel) {
                                        IndexColorModel indexcm = (IndexColorModel)cm;
                                        this.isTransparent = false;
                                        byte[] alphas = new byte[indexcm.getMapSize()];
                                        byte[] reds = new byte[indexcm.getMapSize()];
                                        byte[] greens = new byte[indexcm.getMapSize()];
                                        byte[] blues = new byte[indexcm.getMapSize()];
                                        indexcm.getAlphas(alphas);
                                        indexcm.getReds(reds);
                                        indexcm.getGreens(greens);
                                        indexcm.getBlues(blues);
                                        int i = 0;
                                        while (i < indexcm.getMapSize()) {
                                            if ((alphas[i] & 0xFF) == 0) {
                                                this.isTransparent = true;
                                                this.transparentColor = new Color(reds[i] & 0xFF, greens[i] & 0xFF, blues[i] & 0xFF);
                                                break block20;
                                            }
                                            ++i;
                                        }
                                        break block20;
                                    }
                                    this.isTransparent = false;
                                    break block20;
                                }
                                this.isTransparent = false;
                                break block20;
                            }
                            this.isTransparent = false;
                        }
                        catch (Exception ex) {
                            AbstractFopImage.log.error("Error while loading image (Gif): " + ex.getMessage(), ex);
                            boolean ip = false;
                            Object var14_14 = null;
                            IOUtils.closeQuietly(this.inputStream);
                            this.inputStream = null;
                            return ip;
                        }
                    }
                    Object var14_13 = null;
                    IOUtils.closeQuietly(this.inputStream);
                    this.inputStream = null;
                    break block21;
                }
                catch (Throwable throwable) {
                    Object var14_15 = null;
                    IOUtils.closeQuietly(this.inputStream);
                    this.inputStream = null;
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(this.inputStream);
            this.inputStream = null;
            return bl;
        }
        this.bitmaps = new byte[this.width * this.height * 3];
        int i = 0;
        block8: while (i < this.height) {
            int j = 0;
            while (true) {
                if (j >= this.width) {
                    ++i;
                    continue block8;
                }
                int p = tmpMap[i * this.width + j];
                int r = p >> 16 & 0xFF;
                int g = p >> 8 & 0xFF;
                int b = p & 0xFF;
                this.bitmaps[3 * (i * this.width + j)] = (byte)(r & 0xFF);
                this.bitmaps[3 * (i * this.width + j) + 1] = (byte)(g & 0xFF);
                this.bitmaps[3 * (i * this.width + j) + 2] = (byte)(b & 0xFF);
                ++j;
            }
            break;
        }
        return true;
    }

    protected boolean loadOriginalData() {
        return this.loadDefaultOriginalData();
    }

    protected static class DummyConnection
    extends URLConnection {
        private InputStream inputStream;

        DummyConnection(InputStream is) {
            super(null);
            this.inputStream = is;
        }

        public InputStream getInputStream() throws IOException {
            return this.inputStream;
        }

        public void connect() throws IOException {
        }

        public String getContentType() {
            return "image/gif";
        }

        public int getContentLength() {
            try {
                return this.inputStream.available();
            }
            catch (IOException e) {
                return -1;
            }
        }
    }
}

