/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.layoutmgr.BorderOrPaddingElement;
import org.apache.fop.layoutmgr.BreakElement;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.RelSide;
import org.apache.fop.layoutmgr.SpaceElement;
import org.apache.fop.layoutmgr.UnresolvedListElement;
import org.apache.fop.layoutmgr.UnresolvedListElementWithLength;
import org.apache.fop.traits.MinOptMax;

public class SpaceResolver {
    protected static Log log = LogFactory.getLog(class$org$apache$fop$layoutmgr$SpaceResolver == null ? (class$org$apache$fop$layoutmgr$SpaceResolver = SpaceResolver.class$("org.apache.fop.layoutmgr.SpaceResolver")) : class$org$apache$fop$layoutmgr$SpaceResolver);
    private UnresolvedListElementWithLength[] firstPart;
    private BreakElement breakPoss;
    private UnresolvedListElementWithLength[] secondPart;
    private UnresolvedListElementWithLength[] noBreak;
    private MinOptMax[] firstPartLengths;
    private MinOptMax[] secondPartLengths;
    private MinOptMax[] noBreakLengths;
    private boolean isFirst;
    private boolean isLast;
    static /* synthetic */ Class class$org$apache$fop$layoutmgr$SpaceResolver;

    public SpaceResolver(List first, BreakElement breakPoss, List second, boolean isFirst, boolean isLast) {
        ListIterator iter;
        this.isFirst = isFirst;
        this.isLast = isLast;
        int c = 0;
        if (first != null) {
            c += first.size();
        }
        if (second != null) {
            c += second.size();
        }
        this.noBreak = new UnresolvedListElementWithLength[c];
        this.noBreakLengths = new MinOptMax[c];
        int i = 0;
        if (first != null) {
            iter = first.listIterator();
            while (iter.hasNext()) {
                this.noBreak[i] = (UnresolvedListElementWithLength)iter.next();
                this.noBreakLengths[i] = this.noBreak[i].getLength();
                ++i;
            }
        }
        if (second != null) {
            iter = second.listIterator();
            while (iter.hasNext()) {
                this.noBreak[i] = (UnresolvedListElementWithLength)iter.next();
                this.noBreakLengths[i] = this.noBreak[i].getLength();
                ++i;
            }
        }
        if (breakPoss != null) {
            if (breakPoss.getPendingAfterMarks() != null) {
                if (log.isTraceEnabled()) {
                    log.trace("    adding pending before break: " + breakPoss.getPendingAfterMarks());
                }
                first.addAll(0, breakPoss.getPendingAfterMarks());
            }
            if (breakPoss.getPendingBeforeMarks() != null) {
                if (log.isTraceEnabled()) {
                    log.trace("    adding pending after break: " + breakPoss.getPendingBeforeMarks());
                }
                second.addAll(0, breakPoss.getPendingBeforeMarks());
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("before: " + first);
            log.trace("  break: " + breakPoss);
            log.trace("after: " + second);
            log.trace("NO-BREAK: " + this.toString(this.noBreak, this.noBreakLengths));
        }
        if (first != null) {
            this.firstPart = new UnresolvedListElementWithLength[first.size()];
            this.firstPartLengths = new MinOptMax[this.firstPart.length];
            first.toArray(this.firstPart);
            i = 0;
            while (i < this.firstPart.length) {
                this.firstPartLengths[i] = this.firstPart[i].getLength();
                ++i;
            }
        }
        this.breakPoss = breakPoss;
        if (second != null) {
            this.secondPart = new UnresolvedListElementWithLength[second.size()];
            this.secondPartLengths = new MinOptMax[this.secondPart.length];
            second.toArray(this.secondPart);
            i = 0;
            while (i < this.secondPart.length) {
                this.secondPartLengths[i] = this.secondPart[i].getLength();
                ++i;
            }
        }
        this.resolve();
    }

    private String toString(Object[] arr1, Object[] arr2) {
        if (arr1.length != arr2.length) {
            new IllegalArgumentException("The length of both arrays must be equal");
        }
        StringBuffer sb = new StringBuffer("[");
        int i = 0;
        while (i < arr1.length) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(String.valueOf(arr1[i]));
            sb.append("/");
            sb.append(String.valueOf(arr2[i]));
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    private void removeConditionalBorderAndPadding(UnresolvedListElement[] elems, MinOptMax[] lengths, boolean reverse) {
        int i = 0;
        while (i < elems.length) {
            BorderOrPaddingElement bop;
            int effIndex = reverse ? elems.length - 1 - i : i;
            if (elems[effIndex] instanceof BorderOrPaddingElement && (bop = (BorderOrPaddingElement)elems[effIndex]).isConditional() && !bop.isFirst() && !bop.isLast()) {
                if (log.isDebugEnabled()) {
                    log.debug("Nulling conditional element: " + bop);
                }
                lengths[effIndex] = null;
            }
            ++i;
        }
        if (log.isTraceEnabled() && elems.length > 0) {
            log.trace("-->Resulting list: " + this.toString(elems, lengths));
        }
    }

    private void performSpaceResolutionRule1(UnresolvedListElement[] elems, MinOptMax[] lengths, boolean reverse) {
        int i = 0;
        while (i < elems.length) {
            int effIndex = reverse ? elems.length - 1 - i : i;
            if (lengths[effIndex] != null) {
                if (elems[effIndex] instanceof BorderOrPaddingElement || !elems[effIndex].isConditional()) break;
                if (log.isDebugEnabled()) {
                    log.debug("Nulling conditional element using 4.3.1, rule 1: " + elems[effIndex]);
                }
                lengths[effIndex] = null;
            }
            ++i;
        }
        if (log.isTraceEnabled() && elems.length > 0) {
            log.trace("-->Resulting list: " + this.toString(elems, lengths));
        }
    }

    private void performSpaceResolutionRules2to3(UnresolvedListElement[] elems, MinOptMax[] lengths, int start, int end) {
        SpaceElement space;
        if (log.isTraceEnabled()) {
            log.trace("rule 2-3: " + start + "-" + end);
        }
        boolean hasForcing = false;
        int remaining = 0;
        int i = start;
        while (i <= end) {
            if (lengths[i] != null) {
                ++remaining;
                space = (SpaceElement)elems[i];
                if (space.isForcing()) {
                    hasForcing = true;
                    break;
                }
            }
            ++i;
        }
        if (remaining == 0) {
            return;
        }
        if (hasForcing) {
            int i2 = start;
            while (i2 <= end) {
                if (lengths[i2] != null && !(space = (SpaceElement)elems[i2]).isForcing()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Nulling non-forcing space-specifier using 4.3.1, rule 2: " + elems[i2]);
                    }
                    lengths[i2] = null;
                }
                ++i2;
            }
            return;
        }
        int highestPrecedence = Integer.MIN_VALUE;
        int i3 = start;
        while (i3 <= end) {
            if (lengths[i3] != null) {
                space = (SpaceElement)elems[i3];
                highestPrecedence = Math.max(highestPrecedence, space.getPrecedence());
            }
            ++i3;
        }
        if (highestPrecedence != 0 && log.isDebugEnabled()) {
            log.debug("Highest precedence is " + highestPrecedence);
        }
        remaining = 0;
        int greatestOptimum = Integer.MIN_VALUE;
        int i4 = start;
        while (i4 <= end) {
            if (lengths[i4] != null) {
                space = (SpaceElement)elems[i4];
                if (space.getPrecedence() != highestPrecedence) {
                    if (log.isDebugEnabled()) {
                        log.debug("Nulling space-specifier with precedence " + space.getPrecedence() + " using 4.3.1, rule 3: " + elems[i4]);
                    }
                    lengths[i4] = null;
                } else {
                    greatestOptimum = Math.max(greatestOptimum, space.getLength().opt);
                    ++remaining;
                }
            }
            ++i4;
        }
        if (log.isDebugEnabled()) {
            log.debug("Greatest optimum: " + greatestOptimum);
        }
        if (remaining <= 1) {
            return;
        }
        remaining = 0;
        int i5 = start;
        while (i5 <= end) {
            if (lengths[i5] != null) {
                space = (SpaceElement)elems[i5];
                if (space.getLength().opt < greatestOptimum) {
                    if (log.isDebugEnabled()) {
                        log.debug("Nulling space-specifier with smaller optimum length using 4.3.1, rule 3: " + elems[i5]);
                    }
                    lengths[i5] = null;
                } else {
                    ++remaining;
                }
            }
            ++i5;
        }
        if (remaining <= 1) {
            return;
        }
        int min = Integer.MIN_VALUE;
        int max = Integer.MAX_VALUE;
        int i6 = start;
        while (i6 <= end) {
            if (lengths[i6] != null) {
                space = (SpaceElement)elems[i6];
                min = Math.max(min, space.getLength().min);
                max = Math.min(max, space.getLength().max);
                if (remaining > 1) {
                    if (log.isDebugEnabled()) {
                        log.debug("Nulling non-last space-specifier using 4.3.1, rule 3, second part: " + elems[i6]);
                    }
                    lengths[i6] = null;
                    --remaining;
                } else {
                    lengths[i6].min = min;
                    lengths[i6].max = max;
                }
            }
            ++i6;
        }
        if (log.isTraceEnabled() && elems.length > 0) {
            log.trace("Remaining spaces: " + remaining);
            log.trace("-->Resulting list: " + this.toString(elems, lengths));
        }
    }

    private void performSpaceResolutionRules2to3(UnresolvedListElement[] elems, MinOptMax[] lengths) {
        int start;
        int i = start = 0;
        while (i < elems.length) {
            if (elems[i] instanceof SpaceElement) {
                while (i < elems.length) {
                    if (elems[i] != null && !(elems[i] instanceof SpaceElement)) break;
                    ++i;
                }
                this.performSpaceResolutionRules2to3(elems, lengths, start, i - 1);
            }
            start = ++i;
        }
    }

    private boolean hasFirstPart() {
        return this.firstPart != null && this.firstPart.length > 0;
    }

    private boolean hasSecondPart() {
        return this.secondPart != null && this.secondPart.length > 0;
    }

    private void resolve() {
        if (this.breakPoss != null) {
            if (this.hasFirstPart()) {
                this.removeConditionalBorderAndPadding(this.firstPart, this.firstPartLengths, true);
                this.performSpaceResolutionRule1(this.firstPart, this.firstPartLengths, true);
                this.performSpaceResolutionRules2to3(this.firstPart, this.firstPartLengths);
            }
            if (this.hasSecondPart()) {
                this.removeConditionalBorderAndPadding(this.secondPart, this.secondPartLengths, false);
                this.performSpaceResolutionRule1(this.secondPart, this.secondPartLengths, false);
                this.performSpaceResolutionRules2to3(this.secondPart, this.secondPartLengths);
            }
            if (this.noBreak != null) {
                this.performSpaceResolutionRules2to3(this.noBreak, this.noBreakLengths);
            }
        } else {
            if (this.isFirst) {
                this.removeConditionalBorderAndPadding(this.secondPart, this.secondPartLengths, false);
                this.performSpaceResolutionRule1(this.secondPart, this.secondPartLengths, false);
            }
            if (this.isLast) {
                this.removeConditionalBorderAndPadding(this.firstPart, this.firstPartLengths, true);
                this.performSpaceResolutionRule1(this.firstPart, this.firstPartLengths, true);
            }
            if (this.hasFirstPart()) {
                log.trace("Swapping first and second parts.");
                UnresolvedListElementWithLength[] tempList = this.secondPart;
                MinOptMax[] tempLengths = this.secondPartLengths;
                this.secondPart = this.firstPart;
                this.secondPartLengths = this.firstPartLengths;
                this.firstPart = tempList;
                this.firstPartLengths = tempLengths;
                if (this.hasFirstPart()) {
                    throw new IllegalStateException("Didn't expect more than one parts in ano-break condition.");
                }
            }
            this.performSpaceResolutionRules2to3(this.secondPart, this.secondPartLengths);
        }
    }

    private MinOptMax sum(MinOptMax[] lengths) {
        MinOptMax sum = new MinOptMax();
        int i = 0;
        while (i < lengths.length) {
            if (lengths[i] != null) {
                sum.add(lengths[i]);
            }
            ++i;
        }
        return sum;
    }

    private void generate(ListIterator iter) {
        MinOptMax noBreakLength = new MinOptMax();
        MinOptMax glue1 = this.sum(this.firstPartLengths);
        MinOptMax glue3 = this.sum(this.secondPartLengths);
        noBreakLength = this.sum(this.noBreakLengths);
        int glue2w = noBreakLength.opt - glue1.opt - glue3.opt;
        int glue2stretch = noBreakLength.max - noBreakLength.opt;
        int glue2shrink = noBreakLength.opt - noBreakLength.min;
        glue2stretch -= glue1.max - glue1.opt;
        glue2stretch -= glue3.max - glue3.opt;
        glue2shrink -= glue1.opt - glue1.min;
        glue2shrink -= glue3.opt - glue3.min;
        boolean hasPrecedingNonBlock = false;
        boolean forcedBreak = false;
        if (log.isDebugEnabled()) {
            log.debug("noBreakLength=" + noBreakLength + ", glue1=" + glue1 + ", glue2=" + glue2w + "+" + glue2stretch + "-" + glue2shrink + ", glue3=" + glue3);
        }
        if (this.breakPoss != null) {
            if (glue1.isNonZero()) {
                iter.add(new KnuthPenalty(0, 1000, false, null, true));
                iter.add(new KnuthGlue(glue1.opt, glue1.max - glue1.opt, glue1.opt - glue1.min, null, true));
            }
            iter.add(new KnuthPenalty(this.breakPoss.getPenaltyWidth(), this.breakPoss.getPenaltyValue(), false, this.breakPoss.getBreakClass(), new SpaceHandlingBreakPosition(this, this.breakPoss), false));
            if (this.breakPoss.getPenaltyValue() <= -1000) {
                return;
            }
            if (glue2w != 0 || glue2stretch != 0 || glue2shrink != 0) {
                iter.add(new KnuthGlue(glue2w, glue2stretch, glue2shrink, null, true));
            }
        } else if (glue1.isNonZero()) {
            throw new IllegalStateException("glue1 should be 0 in this case");
        }
        SpaceHandlingPosition pos = null;
        if (this.breakPoss == null) {
            pos = new SpaceHandlingPosition(this);
        }
        if (glue3.isNonZero() || pos != null) {
            iter.add(new KnuthBox(0, pos, true));
        }
        if (glue3.isNonZero()) {
            iter.add(new KnuthPenalty(0, 1000, false, null, true));
            iter.add(new KnuthGlue(glue3.opt, glue3.max - glue3.opt, glue3.opt - glue3.min, null, true));
            hasPrecedingNonBlock = true;
        }
        if (this.isLast && hasPrecedingNonBlock) {
            iter.add(new KnuthBox(0, null, true));
        }
    }

    public static void resolveElementList(LinkedList elems) {
        if (log.isTraceEnabled()) {
            log.trace(elems);
        }
        boolean first = true;
        boolean last = false;
        boolean skipNextElement = false;
        ArrayList<ListElement> unresolvedFirst = new ArrayList<ListElement>();
        ArrayList unresolvedSecond = new ArrayList();
        ListIterator iter = elems.listIterator();
        while (iter.hasNext()) {
            ListElement el = (ListElement)iter.next();
            if (el.isUnresolvedElement()) {
                ArrayList<ListElement> currentGroup;
                if (log.isTraceEnabled()) {
                    log.trace("unresolved found: " + el + " " + first + "/" + last);
                }
                BreakElement breakPoss = null;
                unresolvedFirst.clear();
                unresolvedSecond.clear();
                if (el instanceof BreakElement) {
                    breakPoss = (BreakElement)el;
                    currentGroup = unresolvedSecond;
                } else {
                    currentGroup = unresolvedFirst;
                    currentGroup.add(el);
                }
                iter.remove();
                last = true;
                skipNextElement = true;
                while (iter.hasNext()) {
                    el = (ListElement)iter.next();
                    if (el instanceof BreakElement && breakPoss != null) {
                        skipNextElement = false;
                        last = false;
                        break;
                    }
                    if (currentGroup == unresolvedFirst && el instanceof BreakElement) {
                        breakPoss = (BreakElement)el;
                        iter.remove();
                        currentGroup = unresolvedSecond;
                        continue;
                    }
                    if (el.isUnresolvedElement()) {
                        currentGroup.add(el);
                        iter.remove();
                        continue;
                    }
                    last = false;
                    break;
                }
                if (breakPoss == null && unresolvedSecond.size() == 0 && !last) {
                    log.trace("Swap first and second parts in no-break condition, second part is empty.");
                    ArrayList swapList = unresolvedSecond;
                    unresolvedSecond = unresolvedFirst;
                    unresolvedFirst = swapList;
                }
                log.debug("----start space resolution (first=" + first + ", last=" + last + ")...");
                SpaceResolver resolver = new SpaceResolver(unresolvedFirst, breakPoss, unresolvedSecond, first, last);
                if (!last) {
                    iter.previous();
                }
                resolver.generate(iter);
                if (!last && skipNextElement) {
                    iter.next();
                }
                log.debug("----end space resolution.");
            }
            first = false;
        }
    }

    public static void performConditionalsNotification(List effectiveList, int startElementIndex, int endElementIndex, int prevBreak) {
        Position pos;
        KnuthElement el = null;
        if (prevBreak > 0) {
            el = (KnuthElement)effectiveList.get(prevBreak);
        }
        SpaceHandlingBreakPosition beforeBreak = null;
        SpaceHandlingBreakPosition afterBreak = null;
        if (el != null && el.isPenalty() && (pos = el.getPosition()) instanceof SpaceHandlingBreakPosition) {
            beforeBreak = (SpaceHandlingBreakPosition)pos;
            beforeBreak.notifyBreakSituation(true, RelSide.BEFORE);
        }
        if ((el = (KnuthElement)effectiveList.get(endElementIndex)) != null && el.isPenalty() && (pos = el.getPosition()) instanceof SpaceHandlingBreakPosition) {
            afterBreak = (SpaceHandlingBreakPosition)pos;
            afterBreak.notifyBreakSituation(true, RelSide.AFTER);
        }
        int i = startElementIndex;
        while (i <= endElementIndex) {
            SpaceHandlingBreakPosition noBreak;
            Position pos2 = ((KnuthElement)effectiveList.get(i)).getPosition();
            if (pos2 instanceof SpaceHandlingPosition) {
                ((SpaceHandlingPosition)pos2).notifySpaceSituation();
            } else if (pos2 instanceof SpaceHandlingBreakPosition && (noBreak = (SpaceHandlingBreakPosition)pos2) != beforeBreak && noBreak != afterBreak) {
                noBreak.notifyBreakSituation(false, null);
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class SpaceHandlingPosition
    extends Position {
        private SpaceResolver resolver;

        public SpaceHandlingPosition(SpaceResolver resolver) {
            super(null);
            this.resolver = resolver;
        }

        public SpaceResolver getSpaceResolver() {
            return this.resolver;
        }

        public void notifySpaceSituation() {
            if (this.resolver.breakPoss != null) {
                throw new IllegalStateException("Only applicable to no-break situations");
            }
            int i = 0;
            while (i < this.resolver.secondPart.length) {
                this.resolver.secondPart[i].notifyLayoutManager(this.resolver.secondPartLengths[i]);
                ++i;
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("SpaceHandlingPosition");
            return sb.toString();
        }
    }

    public class SpaceHandlingBreakPosition
    extends Position {
        private SpaceResolver resolver;
        private Position originalPosition;

        public SpaceHandlingBreakPosition(SpaceResolver resolver, BreakElement breakPoss) {
            super(null);
            this.resolver = resolver;
            this.originalPosition = breakPoss.getPosition();
            while (this.originalPosition instanceof NonLeafPosition) {
                this.originalPosition = this.originalPosition.getPosition();
            }
        }

        public SpaceResolver getSpaceResolver() {
            return this.resolver;
        }

        public void notifyBreakSituation(boolean isBreakSituation, RelSide side) {
            if (isBreakSituation) {
                if (RelSide.BEFORE == side) {
                    int i = 0;
                    while (i < this.resolver.secondPart.length) {
                        this.resolver.secondPart[i].notifyLayoutManager(this.resolver.secondPartLengths[i]);
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < this.resolver.firstPart.length) {
                        this.resolver.firstPart[i].notifyLayoutManager(this.resolver.firstPartLengths[i]);
                        ++i;
                    }
                }
            } else {
                int i = 0;
                while (i < this.resolver.noBreak.length) {
                    this.resolver.noBreak[i].notifyLayoutManager(this.resolver.noBreakLengths[i]);
                    ++i;
                }
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("SpaceHandlingBreakPosition(");
            sb.append(this.originalPosition);
            sb.append(")");
            return sb.toString();
        }

        public Position getOriginalBreakPosition() {
            return this.originalPosition;
        }
    }
}

