/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.fop.fo.flow.TableRow;
import org.apache.fop.layoutmgr.table.GridUnit;
import org.apache.fop.traits.MinOptMax;

public class EffRow {
    public static final int FIRST_IN_BODY = 3;
    public static final int LAST_IN_BODY = 4;
    private List gridUnits = new ArrayList();
    private int index;
    private int bodyType;
    private MinOptMax height;
    private MinOptMax explicitHeight;

    public EffRow(int index, int bodyType) {
        this.index = index;
        this.bodyType = bodyType;
    }

    public int getIndex() {
        return this.index;
    }

    public int getBodyType() {
        return this.bodyType;
    }

    public TableRow getTableRow() {
        return this.getGridUnit(0).getRow();
    }

    public MinOptMax getHeight() {
        return this.height;
    }

    public void setHeight(MinOptMax mom) {
        this.height = mom;
    }

    public MinOptMax getExplicitHeight() {
        return this.explicitHeight;
    }

    public void setExplicitHeight(MinOptMax mom) {
        this.explicitHeight = mom;
    }

    public List getGridUnits() {
        return this.gridUnits;
    }

    public GridUnit getGridUnit(int column) {
        return (GridUnit)this.gridUnits.get(column);
    }

    public GridUnit safelyGetGridUnit(int column) {
        if (column < this.gridUnits.size()) {
            return (GridUnit)this.gridUnits.get(column);
        }
        return null;
    }

    public void setFlagForAllGridUnits(int flag, boolean value) {
        Iterator iter = this.gridUnits.iterator();
        while (iter.hasNext()) {
            GridUnit gu = (GridUnit)iter.next();
            gu.setFlag(flag, value);
        }
    }

    public boolean getFlag(int which) {
        if (which == 3) {
            return this.getGridUnit(0).getFlag(3);
        }
        if (which == 4) {
            return this.getGridUnit(0).getFlag(4);
        }
        throw new IllegalArgumentException("Illegal flag queried: " + which);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("EffRow {");
        sb.append(this.index);
        if (this.getBodyType() == 0) {
            sb.append(" in body");
        } else if (this.getBodyType() == 1) {
            sb.append(" in header");
        } else {
            sb.append(" in footer");
        }
        sb.append(", ").append(this.height);
        sb.append(", ").append(this.explicitHeight);
        sb.append(", ").append(this.gridUnits.size()).append(" gu");
        sb.append("}");
        return sb.toString();
    }
}

