/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import java.util.LinkedList;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.area.Trait;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.flow.Table;
import org.apache.fop.fo.flow.TableCell;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.layoutmgr.AbstractBaseLayoutManager;
import org.apache.fop.layoutmgr.AreaAdditionUtil;
import org.apache.fop.layoutmgr.BlockLevelLayoutManager;
import org.apache.fop.layoutmgr.BlockStackingLayoutManager;
import org.apache.fop.layoutmgr.BreakElement;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpaceResolver;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.table.GridUnit;
import org.apache.fop.layoutmgr.table.PrimaryGridUnit;
import org.apache.fop.layoutmgr.table.TableLayoutManager;
import org.apache.fop.traits.MinOptMax;

public class TableCellLayoutManager
extends BlockStackingLayoutManager
implements BlockLevelLayoutManager {
    private PrimaryGridUnit gridUnit;
    private Block curBlockArea;
    private int inRowIPDOffset;
    private int xoffset;
    private int yoffset;
    private int cellIPD;
    private int rowHeight;
    private int usedBPD;
    private int startBorderWidth;
    private int endBorderWidth;
    private int borderAndPaddingBPD;
    private boolean emptyCell = true;

    public TableCellLayoutManager(TableCell node, PrimaryGridUnit pgu) {
        super(node);
        this.fobj = node;
        this.gridUnit = pgu;
    }

    public TableCell getTableCell() {
        return (TableCell)this.fobj;
    }

    private boolean isSeparateBorderModel() {
        return this.getTable().isSeparateBorderModel();
    }

    public void initialize() {
        this.borderAndPaddingBPD = 0;
        this.borderAndPaddingBPD += this.getTableCell().getCommonBorderPaddingBackground().getBorderBeforeWidth(false);
        this.borderAndPaddingBPD += this.getTableCell().getCommonBorderPaddingBackground().getBorderAfterWidth(false);
        if (!this.isSeparateBorderModel()) {
            this.borderAndPaddingBPD /= 2;
        }
        this.borderAndPaddingBPD += this.getTableCell().getCommonBorderPaddingBackground().getPaddingBefore(false, this);
        this.borderAndPaddingBPD += this.getTableCell().getCommonBorderPaddingBackground().getPaddingAfter(false, this);
    }

    public Table getTable() {
        FONode node = this.fobj.getParent();
        while (!(node instanceof Table)) {
            node = node.getParent();
        }
        return (Table)node;
    }

    protected int getIPIndents() {
        int iIndents = 0;
        int[] startEndBorderWidths = this.gridUnit.getStartEndBorderWidths();
        this.startBorderWidth += startEndBorderWidths[0];
        this.endBorderWidth += startEndBorderWidths[1];
        iIndents += this.startBorderWidth;
        iIndents += this.endBorderWidth;
        if (!this.isSeparateBorderModel()) {
            iIndents /= 2;
        }
        iIndents += this.getTableCell().getCommonBorderPaddingBackground().getPaddingStart(false, this);
        return iIndents += this.getTableCell().getCommonBorderPaddingBackground().getPaddingEnd(false, this);
    }

    /*
     * WARNING - void declaration
     */
    public LinkedList getNextKnuthElements(LayoutContext context, int alignment) {
        BlockLevelLayoutManager curLM;
        MinOptMax stackLimit = new MinOptMax(context.getStackLimit());
        this.cellIPD = this.referenceIPD = context.getRefIPD();
        this.cellIPD -= this.getIPIndents();
        if (this.isSeparateBorderModel()) {
            int borderSep = this.getTable().getBorderSeparation().getLengthPair().getIPD().getLength().getValue(this);
            this.cellIPD -= borderSep;
        }
        LinkedList returnedList = null;
        LinkedList contentList = new LinkedList();
        LinkedList returnList = new LinkedList();
        Object prevLM = null;
        while ((curLM = (BlockLevelLayoutManager)this.getChildLM()) != null) {
            void var7_9;
            LayoutContext childLC = new LayoutContext(0);
            childLC.setStackLimit(MinOptMax.subtract(context.getStackLimit(), stackLimit));
            childLC.setRefIPD(this.cellIPD);
            returnedList = var7_9.getNextKnuthElements(childLC, alignment);
            if (childLC.isKeepWithNextPending()) {
                AbstractBaseLayoutManager.log.debug("child LM signals pending keep with next");
            }
            if (contentList.size() == 0 && childLC.isKeepWithPreviousPending()) {
                context.setFlags(1024);
                childLC.setFlags(1024, false);
            }
            if (returnedList.size() == 1 && ((ListElement)returnedList.getFirst()).isForcedBreak()) {
                if (returnList.size() == 0) {
                    // empty if block
                }
                contentList.addAll(returnedList);
                returnedList = new LinkedList();
                this.wrapPositionElements(contentList, returnList);
                SpaceResolver.resolveElementList(returnList);
                return returnList;
            }
            if (prevLM != null) {
                if (this.mustKeepTogether() || context.isKeepWithNextPending() || childLC.isKeepWithPreviousPending()) {
                    context.setFlags(512, false);
                    childLC.setFlags(1024, false);
                    contentList.add(new BreakElement(new Position(this), 1000, context));
                } else if (!((ListElement)contentList.getLast()).isGlue()) {
                    contentList.add(new BreakElement(new Position(this), 0, context));
                }
            }
            contentList.addAll(returnedList);
            if (returnedList.size() == 0) continue;
            if (((ListElement)returnedList.getLast()).isForcedBreak()) {
                if (var7_9.isFinished()) {
                    this.setFinished(true);
                }
                returnedList = new LinkedList();
                this.wrapPositionElements(contentList, returnList);
                SpaceResolver.resolveElementList(returnList);
                return returnList;
            }
            if (childLC.isKeepWithNextPending()) {
                childLC.setFlags(512, false);
                context.setFlags(512);
            }
            prevLM = var7_9;
        }
        returnedList = new LinkedList();
        this.wrapPositionElements(contentList, returnList);
        SpaceResolver.resolveElementList(returnList);
        this.setFinished(true);
        return returnList;
    }

    public void setYOffset(int off) {
        this.yoffset = off;
    }

    public void setXOffset(int off) {
        this.xoffset = off;
    }

    public void setInRowIPDOffset(int off) {
        this.inRowIPDOffset = off;
    }

    public void setContentHeight(int h) {
        this.usedBPD = h;
    }

    public void setRowHeight(int h) {
        this.rowHeight = h;
    }

    private int getContentHeight(int rowHeight, GridUnit gu) {
        int bpd = rowHeight;
        if (this.isSeparateBorderModel()) {
            bpd -= gu.getPrimary().getBorders().getBorderBeforeWidth(false);
            bpd -= gu.getPrimary().getBorders().getBorderAfterWidth(false);
        } else {
            bpd -= gu.getPrimary().getHalfMaxBorderWidth();
        }
        CommonBorderPaddingBackground cbpb = gu.getCell().getCommonBorderPaddingBackground();
        bpd -= cbpb.getPaddingBefore(false, this);
        bpd -= cbpb.getPaddingAfter(false, this);
        return bpd -= 2 * ((TableLayoutManager)this.getParent()).getHalfBorderSeparationBPD();
    }

    public void addAreas(PositionIterator parentIter, LayoutContext layoutContext) {
        int contentBPD;
        this.getParentArea(null);
        this.getPSLM().addIDToPage(this.getTableCell().getId());
        if (this.isSeparateBorderModel()) {
            if (!this.emptyCell || this.getTableCell().showEmptyCells()) {
                TraitSetter.addBorders(this.curBlockArea, this.getTableCell().getCommonBorderPaddingBackground(), this);
            }
        } else {
            boolean[] outer = new boolean[]{this.gridUnit.getFlag(2), this.gridUnit.getFlag(5), this.gridUnit.getFlag(0), this.gridUnit.getFlag(1)};
            if (!this.gridUnit.hasSpanning()) {
                TraitSetter.addCollapsingBorders(this.curBlockArea, this.gridUnit.getBorders(), outer, this);
            } else {
                int dy = this.yoffset;
                int y = 0;
                while (y < this.gridUnit.getRows().size()) {
                    GridUnit[] gridUnits = (GridUnit[])this.gridUnit.getRows().get(y);
                    int dx = this.xoffset;
                    int lastRowHeight = 0;
                    int x = 0;
                    while (x < gridUnits.length) {
                        GridUnit gu = gridUnits[x];
                        if (gu.hasBorders()) {
                            Block block = new Block();
                            block.addTrait(Trait.IS_REFERENCE_AREA, Boolean.TRUE);
                            block.setPositioning(2);
                            int bpd = this.getContentHeight(this.rowHeight, gu);
                            if (this.isSeparateBorderModel()) {
                                bpd += gu.getBorders().getBorderBeforeWidth(false);
                                bpd += gu.getBorders().getBorderAfterWidth(false);
                            } else {
                                bpd += this.gridUnit.getHalfMaxBeforeBorderWidth() - gu.getBorders().getBorderBeforeWidth(false) / 2;
                                bpd += this.gridUnit.getHalfMaxAfterBorderWidth() - gu.getBorders().getBorderAfterWidth(false) / 2;
                            }
                            block.setBPD(bpd);
                            lastRowHeight = this.rowHeight;
                            int ipd = gu.getColumn().getColumnWidth().getValue(this);
                            int borderStartWidth = gu.getBorders().getBorderStartWidth(false) / 2;
                            ipd -= borderStartWidth;
                            block.setIPD(ipd -= gu.getBorders().getBorderEndWidth(false) / 2);
                            block.setXOffset(dx + borderStartWidth);
                            int halfCollapsingBorderHeight = 0;
                            if (!this.isSeparateBorderModel()) {
                                halfCollapsingBorderHeight += gu.getBorders().getBorderBeforeWidth(false) / 2;
                            }
                            block.setYOffset(dy - halfCollapsingBorderHeight);
                            TraitSetter.addCollapsingBorders(block, gu.getBorders(), outer, this);
                            this.parentLM.addChildArea(block);
                            dx += gu.getColumn().getColumnWidth().getValue(this);
                        }
                        ++x;
                    }
                    dy += lastRowHeight;
                    ++y;
                }
                AbstractBaseLayoutManager.log.warn("TODO Add collapsed border painting for spanned cells");
            }
        }
        if (this.usedBPD < (contentBPD = this.getContentHeight(this.rowHeight, this.gridUnit))) {
            if (this.getTableCell().getDisplayAlign() == 23) {
                Block space = new Block();
                space.setBPD((contentBPD - this.usedBPD) / 2);
                this.curBlockArea.addBlock(space);
            } else if (this.getTableCell().getDisplayAlign() == 3) {
                Block space = new Block();
                space.setBPD(contentBPD - this.usedBPD);
                this.curBlockArea.addBlock(space);
            }
        }
        AreaAdditionUtil.addAreas(this, parentIter, layoutContext);
        this.curBlockArea.setBPD(contentBPD);
        if (this.isSeparateBorderModel()) {
            if (!this.emptyCell || this.getTableCell().showEmptyCells()) {
                TraitSetter.addBackground(this.curBlockArea, this.getTableCell().getCommonBorderPaddingBackground(), this);
            }
        } else {
            TraitSetter.addBackground(this.curBlockArea, this.getTableCell().getCommonBorderPaddingBackground(), this);
        }
        this.flush();
        this.curBlockArea = null;
    }

    public Area getParentArea(Area childArea) {
        if (this.curBlockArea == null) {
            this.curBlockArea = new Block();
            this.curBlockArea.addTrait(Trait.IS_REFERENCE_AREA, Boolean.TRUE);
            TraitSetter.setProducerID(this.curBlockArea, this.getTableCell().getId());
            this.curBlockArea.setPositioning(2);
            int indent = 0;
            indent += this.startBorderWidth;
            if (!this.isSeparateBorderModel()) {
                indent /= 2;
            }
            indent += this.getTableCell().getCommonBorderPaddingBackground().getPaddingStart(false, this);
            int borderAdjust = 0;
            if (!this.isSeparateBorderModel()) {
                borderAdjust = this.gridUnit.hasSpanning() ? (borderAdjust -= this.gridUnit.getHalfMaxBeforeBorderWidth()) : (borderAdjust += this.gridUnit.getHalfMaxBeforeBorderWidth());
            }
            TableLayoutManager tableLM = (TableLayoutManager)this.getParent();
            this.curBlockArea.setXOffset(this.xoffset + this.inRowIPDOffset + tableLM.getHalfBorderSeparationIPD() + indent);
            this.curBlockArea.setYOffset(this.yoffset - borderAdjust + tableLM.getHalfBorderSeparationBPD());
            this.curBlockArea.setIPD(this.cellIPD);
            this.parentLM.getParentArea(this.curBlockArea);
            this.setCurrentArea(this.curBlockArea);
        }
        return this.curBlockArea;
    }

    public void addChildArea(Area childArea) {
        if (this.curBlockArea != null) {
            this.curBlockArea.addBlock((Block)childArea);
        }
    }

    public void resetPosition(Position resetPos) {
        if (resetPos == null) {
            this.reset(null);
        }
    }

    public int negotiateBPDAdjustment(int adj, KnuthElement lastElement) {
        return 0;
    }

    public void discardSpace(KnuthGlue spaceGlue) {
    }

    public boolean mustKeepTogether() {
        boolean keep = ((BlockLevelLayoutManager)this.getParent()).mustKeepTogether();
        if (this.gridUnit.getRow() != null) {
            keep |= this.gridUnit.getRow().mustKeepTogether();
        }
        return keep;
    }

    public boolean mustKeepWithPrevious() {
        return false;
    }

    public boolean mustKeepWithNext() {
        return false;
    }

    public int getContentAreaIPD() {
        return this.cellIPD;
    }

    public int getContentAreaBPD() {
        if (this.curBlockArea != null) {
            return this.curBlockArea.getBPD();
        }
        AbstractBaseLayoutManager.log.error("getContentAreaBPD called on unknown BPD");
        return -1;
    }

    public boolean getGeneratesReferenceArea() {
        return true;
    }

    public boolean getGeneratesBlockArea() {
        return true;
    }
}

