/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.bitmap;

import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.fop.apps.FOPException;
import org.apache.fop.area.PageViewport;
import org.apache.fop.render.AbstractRenderer;
import org.apache.fop.render.java2d.Java2DRenderer;
import org.apache.xmlgraphics.image.writer.ImageWriter;
import org.apache.xmlgraphics.image.writer.ImageWriterParams;
import org.apache.xmlgraphics.image.writer.ImageWriterRegistry;

public class PNGRenderer
extends Java2DRenderer {
    public static final String MIME_TYPE = "image/png";
    private String filePrefix;
    private File outputDir;
    private OutputStream firstOutputStream;

    public String getMimeType() {
        return MIME_TYPE;
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        AbstractRenderer.log.info("rendering areas to PNG");
        this.setOutputDirectory();
        this.firstOutputStream = outputStream;
    }

    private void setOutputDirectory() {
        File f = this.getUserAgent().getOutputFile();
        if (f == null) {
            this.outputDir = null;
            this.filePrefix = null;
        } else {
            int i;
            this.outputDir = f.getParentFile();
            String s = f.getName();
            if (s.charAt((i = s.lastIndexOf(".")) - 1) == '1') {
                --i;
            }
            this.filePrefix = s.substring(0, i);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stopRenderer() throws IOException {
        super.stopRenderer();
        int i = 0;
        while (true) {
            block5: {
                Object var7_6;
                if (i >= this.pageViewportList.size()) {
                    return;
                }
                OutputStream os = this.getCurrentOutputStream(i);
                if (os == null) {
                    AbstractRenderer.log.warn("No filename information available. Stopping early after the first page.");
                    return;
                }
                try {
                    BufferedImage image = this.getPageImage((PageViewport)this.pageViewportList.get(i));
                    AbstractRenderer.log.debug("Encoding page " + (i + 1));
                    ImageWriterParams params = new ImageWriterParams();
                    params.setResolution(Math.round(this.userAgent.getTargetResolution()));
                    ImageWriter writer = ImageWriterRegistry.getInstance().getWriterFor(this.getMimeType());
                    AbstractRenderer.log.debug("Writing image using " + writer.getClass().getName());
                    writer.writeImage(image, os, params);
                    var7_6 = null;
                    if (os == this.firstOutputStream) break block5;
                }
                catch (Throwable throwable) {
                    var7_6 = null;
                    if (os == this.firstOutputStream) throw throwable;
                    IOUtils.closeQuietly(os);
                    throw throwable;
                }
                IOUtils.closeQuietly(os);
            }
            ++i;
        }
    }

    private OutputStream getCurrentOutputStream(int pageNumber) {
        if (pageNumber == 0) {
            return this.firstOutputStream;
        }
        if (this.filePrefix == null) {
            return null;
        }
        File f = new File(this.outputDir, this.filePrefix + (pageNumber + 1) + ".png");
        try {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));
            return os;
        }
        catch (FileNotFoundException e) {
            new FOPException("Can't build the OutputStream\n" + e);
            return null;
        }
    }
}

