/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.tools.anttasks;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.fop.hyphenation.HyphenationException;
import org.apache.fop.hyphenation.HyphenationTree;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class SerializeHyphPattern
extends Task {
    private List filesets = new ArrayList();
    private File targetDir;
    private boolean errorDump = false;

    public void execute() throws BuildException {
        int i = 0;
        while (i < this.getFilesets().size()) {
            FileSet fs = (FileSet)this.getFilesets().get(i);
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            File basedir = ds.getBasedir();
            String[] files = ds.getIncludedFiles();
            int j = 0;
            while (j < files.length) {
                this.processFile(basedir, files[j].substring(0, files[j].length() - 4));
                ++j;
            }
            ++i;
        }
    }

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public List getFilesets() {
        return this.filesets;
    }

    public void setTargetDir(String targetDir) {
        File dir;
        this.targetDir = dir = new File(targetDir);
    }

    public void setErrorDump(boolean errorDump) {
        this.errorDump = errorDump;
    }

    private void processFile(File basedir, String filename) {
        File infile = new File(basedir, filename + ".xml");
        File outfile = new File(this.targetDir, filename + ".hyp");
        boolean startProcess = true;
        startProcess = this.rebuild(infile, outfile);
        if (startProcess) {
            this.buildPatternFile(infile, outfile);
        }
    }

    private void buildPatternFile(File infile, File outfile) {
        HyphenationTree hTree;
        block5: {
            System.out.println("Processing " + infile);
            hTree = new HyphenationTree();
            try {
                hTree.loadPatterns(infile.toString());
                if (this.errorDump) {
                    System.out.println("Stats: ");
                    hTree.printStats();
                }
            }
            catch (HyphenationException ex) {
                System.err.println("Can't load patterns from xml file " + infile + " - Maybe hyphenation.dtd is missing?");
                if (!this.errorDump) break block5;
                System.err.println(ex.toString());
            }
        }
        try {
            ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(outfile)));
            out.writeObject(hTree);
            out.close();
        }
        catch (IOException ioe) {
            System.err.println("Can't write compiled pattern file: " + outfile);
            System.err.println(ioe);
        }
    }

    private boolean rebuild(File infile, File outfile) {
        if (outfile.exists()) {
            return outfile.lastModified() < infile.lastModified();
        }
        return true;
    }
}

